/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.SdkConstants;
import com.android.io.CancellableFileIo;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.PackageParserUtils;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.OptionalLibraryImpl;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlatformTarget
implements IAndroidTarget {
    public static final String PLATFORM_VENDOR = "Android Open Source Project";
    private static final String PLATFORM_NAME = "Android %s";
    private static final String PLATFORM_NAME_PREVIEW = "Android %s (Preview)";
    private final LocalPackage mPackage;
    private final DetailsTypes.PlatformDetailsType mDetails;
    private List<OptionalLibrary> mOptionalLibraries = ImmutableList.of();
    private final Set<Path> mSkins;
    private Map<String, String> mBuildProps;
    private final BuildToolInfo mBuildToolInfo;
    private Path mSourcesPath = null;

    public PlatformTarget(LocalPackage p, AndroidSdkHandler sdkHandler, ProgressIndicator progress) {
        Path buildProp;
        Path optionalJson;
        this.mPackage = p;
        TypeDetails details = p.getTypeDetails();
        assert (details instanceof DetailsTypes.PlatformDetailsType);
        this.mDetails = (DetailsTypes.PlatformDetailsType)details;
        Path optionalDir = p.getLocation().resolve("optional");
        if (CancellableFileIo.isDirectory((Path)optionalDir, (LinkOption[])new LinkOption[0]) && CancellableFileIo.isRegularFile((Path)(optionalJson = optionalDir.resolve("optional.json")), (LinkOption[])new LinkOption[0])) {
            this.mOptionalLibraries = PlatformTarget.getLibsFromJson(optionalJson);
        }
        if (!CancellableFileIo.isRegularFile((Path)(buildProp = this.mPackage.getLocation().resolve("build.prop")), (LinkOption[])new LinkOption[0])) {
            String message = "Build properties not found for package " + p.getDisplayName();
            progress.logWarning(message);
            throw new IllegalArgumentException(message);
        }
        try {
            this.mBuildProps = ProjectProperties.parsePropertyStream(CancellableFileIo.newInputStream((Path)buildProp, (OpenOption[])new OpenOption[0]), buildProp.toString(), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mBuildProps == null) {
            this.mBuildProps = Maps.newHashMap();
        }
        this.mBuildToolInfo = sdkHandler.getLatestBuildTool(progress, null, this.getVersion().isPreview());
        this.mSkins = Sets.newTreeSet(PackageParserUtils.parseSkinFolder(this.getPath(5)));
    }

    public void setSources(Path location) {
        this.mSourcesPath = location;
    }

    public static List<OptionalLibrary> getLibsFromJson(Path jsonFile) {
        Gson gson = new Gson();
        try {
            Collection libs;
            Type collectionType = new TypeToken<Collection<Library>>(){}.getType();
            try (BufferedReader reader = CancellableFileIo.newBufferedReader((Path)jsonFile);){
                libs = (Collection)gson.fromJson((Reader)reader, collectionType);
            }
            ArrayList optionalLibraries = Lists.newArrayListWithCapacity((int)libs.size());
            Path rootFolder = jsonFile.getParent();
            for (Library lib : libs) {
                optionalLibraries.add(new OptionalLibraryImpl(lib.name, rootFolder.resolve(lib.jar), lib.name, lib.manifest));
            }
            return optionalLibraries;
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public String getLocation() {
        return this.mPackage.getLocation().toString() + File.separator;
    }

    @Override
    public String getVendor() {
        return PLATFORM_VENDOR;
    }

    @Override
    public String getName() {
        AndroidVersion version = this.getVersion();
        if (version.isPreview()) {
            return String.format(PLATFORM_NAME_PREVIEW, version);
        }
        return String.format(PLATFORM_NAME, version);
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mDetails.getAndroidVersion();
    }

    @Override
    public String getVersionName() {
        return SdkVersionInfo.getVersionString(this.mDetails.getApiLevel());
    }

    @Override
    public int getRevision() {
        return this.mPackage.getVersion().getMajor();
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @Override
    public IAndroidTarget getParent() {
        return null;
    }

    @Override
    public Path getPath(int pathId) {
        Path location = this.mPackage.getLocation();
        switch (pathId) {
            case 1: {
                return location.resolve("android.jar");
            }
            case 27: {
                return location.resolve("uiautomator.jar");
            }
            case 18: {
                if (this.mSourcesPath != null) {
                    return this.mSourcesPath;
                }
                return location.resolve("sources");
            }
            case 2: {
                return location.resolve("framework.aidl");
            }
            case 4: {
                return location.resolve(SdkConstants.OS_PLATFORM_SAMPLES_FOLDER);
            }
            case 5: {
                return location.resolve(SdkConstants.OS_SKINS_FOLDER);
            }
            case 6: {
                return location.resolve(SdkConstants.OS_PLATFORM_TEMPLATES_FOLDER);
            }
            case 7: {
                return location.resolve(SdkConstants.OS_PLATFORM_DATA_FOLDER);
            }
            case 8: {
                return location.resolve(SdkConstants.OS_PLATFORM_ATTRS_XML);
            }
            case 9: {
                return location.resolve(SdkConstants.OS_PLATFORM_ATTRS_MANIFEST_XML);
            }
            case 11: {
                return location.resolve(SdkConstants.OS_PLATFORM_RESOURCES_FOLDER);
            }
            case 12: {
                return location.resolve(SdkConstants.OS_PLATFORM_FONTS_FOLDER);
            }
            case 10: {
                return location.resolve(SdkConstants.OS_PLATFORM_DATA_FOLDER).resolve("layoutlib.jar");
            }
            case 13: {
                return location.resolve(SdkConstants.OS_PLATFORM_DATA_FOLDER).resolve("widgets.txt");
            }
            case 14: {
                return location.resolve(SdkConstants.OS_PLATFORM_DATA_FOLDER).resolve("activity_actions.txt");
            }
            case 15: {
                return location.resolve(SdkConstants.OS_PLATFORM_DATA_FOLDER).resolve("broadcast_actions.txt");
            }
            case 16: {
                return location.resolve(SdkConstants.OS_PLATFORM_DATA_FOLDER).resolve("service_actions.txt");
            }
            case 17: {
                return location.resolve(SdkConstants.OS_PLATFORM_DATA_FOLDER).resolve("categories.txt");
            }
            case 24: {
                return location.resolve(SdkConstants.OS_PLATFORM_ANT_FOLDER);
            }
            case 28: {
                return location.resolve("core-for-system-modules.jar");
            }
        }
        return location;
    }

    @Override
    public BuildToolInfo getBuildToolInfo() {
        return this.mBuildToolInfo;
    }

    @Override
    public List<String> getBootClasspath() {
        return ImmutableList.of((Object)this.getPath(1).toString());
    }

    @Override
    public List<OptionalLibrary> getOptionalLibraries() {
        return this.mOptionalLibraries;
    }

    @Override
    public List<OptionalLibrary> getAdditionalLibraries() {
        return ImmutableList.of();
    }

    @Override
    public boolean hasRenderingLibrary() {
        return true;
    }

    @Override
    public Path[] getSkins() {
        return this.mSkins.toArray(new Path[0]);
    }

    public int getLayoutlibApi() {
        return this.mDetails.getLayoutlib().getApi();
    }

    @Override
    public Path getDefaultSkin() {
        if (this.mSkins.size() == 1) {
            return this.mSkins.iterator().next();
        }
        String skinName = this.getVersion().getApiLevel() >= 11 && this.getVersion().getApiLevel() <= 13 ? "WXGA" : (this.getVersion().getApiLevel() >= 4 ? "WVGA800" : "HVGA");
        return this.getPath(5).resolve(skinName);
    }

    @Override
    public String[] getPlatformLibraries() {
        return new String[]{"android.test.runner"};
    }

    @Override
    public String getProperty(String name) {
        return this.mBuildProps.get(name);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.mBuildProps;
    }

    @Override
    public String getShortClasspathName() {
        return this.getName();
    }

    @Override
    public String getClasspathName() {
        return this.getName();
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        if (this.getVersion().isPreview()) {
            return target.getVersion().equals((Object)this.getVersion());
        }
        return target.getVersion().getApiLevel() > this.getVersion().getApiLevel();
    }

    @Override
    public String hashString() {
        return AndroidTargetHash.getPlatformHashString(this.getVersion());
    }

    @Override
    public int compareTo(IAndroidTarget o) {
        int res = this.getVersion().compareTo(o.getVersion());
        if (res != 0) {
            return res;
        }
        return o.isPlatform() ? 0 : -1;
    }

    public boolean equals(Object obj) {
        return obj instanceof PlatformTarget && this.compareTo((PlatformTarget)obj) == 0;
    }

    public int hashCode() {
        return this.hashString().hashCode();
    }

    public static class Library {
        String name;
        String jar;
        boolean manifest;
    }
}

