/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.android.testutils.OsType;
import com.android.testutils.filesystemdiff.Action;
import com.android.testutils.filesystemdiff.ActionExecutor;
import com.android.testutils.filesystemdiff.FileSystemEntry;
import com.android.testutils.filesystemdiff.Script;
import com.android.testutils.filesystemdiff.SymbolicLinkDefinition;
import com.android.testutils.filesystemdiff.TreeBuilder;
import com.android.testutils.filesystemdiff.TreeDifferenceEngine;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class BazelRunfilesManifestProcessor {
    public static final String RUNFILES_MANIFEST_FILE_ENV = "RUNFILES_MANIFEST_FILE";
    public static final String TEST_SRCDIR_ENV = "TEST_SRCDIR";
    public static final ILogger logger = new StdLogger(StdLogger.Level.INFO);

    private static boolean isWindows() {
        return OsType.getHostOs() == OsType.WINDOWS;
    }

    public static void setUpRunfiles() {
        if (!BazelRunfilesManifestProcessor.isWindows()) {
            return;
        }
        BazelRunfilesManifestProcessor.setUpRunfiles(System.getenv());
    }

    @VisibleForTesting
    static void setUpRunfiles(Map<String, String> env) {
        String manifestFilename = env.get(RUNFILES_MANIFEST_FILE_ENV);
        if (manifestFilename == null) {
            return;
        }
        Path testSourcePath = Paths.get(env.get(TEST_SRCDIR_ENV), new String[0]);
        if (testSourcePath == null) {
            return;
        }
        long startTime = System.nanoTime();
        final Path manifestPath = Paths.get(manifestFilename, new String[0]).toAbsolutePath();
        List<SymbolicLinkDefinition> links = BazelRunfilesManifestProcessor.readRunfilesManifest(manifestPath, testSourcePath);
        long endTime = System.nanoTime();
        logger.info("RUNFILES: Loaded runfiles manifest \"%s\" in %,d msec", new Object[]{manifestPath, (endTime - startTime) / 1000000L});
        startTime = System.nanoTime();
        FileSystemEntry fileSystemRoot = TreeBuilder.buildFromFileSystem(testSourcePath);
        FileSystemEntry manifestRoot = TreeBuilder.buildFromSymbolicLinkDefinitions(testSourcePath, links);
        endTime = System.nanoTime();
        logger.info("RUNFILES: Traversed existing file system (%,d entries) in %,d msec", new Object[]{BazelRunfilesManifestProcessor.countEntries(fileSystemRoot), (endTime - startTime) / 1000000L});
        startTime = System.nanoTime();
        Script script = TreeDifferenceEngine.computeEditScript(fileSystemRoot, manifestRoot);
        endTime = System.nanoTime();
        logger.info("RUNFILES: Computed file system edit script (%,d actions) in %,d msec", new Object[]{script.getActions().size(), (endTime - startTime) / 1000000L});
        startTime = System.nanoTime();
        script.execute(logger, new ActionExecutor(){

            @Override
            public void execute(ILogger logger, Action action) {
                if (action.getSourceEntry().getPath().equals(manifestPath)) {
                    return;
                }
                super.execute(logger, action);
            }
        });
        endTime = System.nanoTime();
        logger.info("RUNFILES: Synchronized file system in %,d msec", new Object[]{(endTime - startTime) / 1000000L});
    }

    private static int countEntries(FileSystemEntry fileSystemRoot) {
        int result = 1;
        for (FileSystemEntry child : fileSystemRoot.getChildEntries()) {
            result += BazelRunfilesManifestProcessor.countEntries(child);
        }
        return result;
    }

    private static List<SymbolicLinkDefinition> readRunfilesManifest(Path manifestPath, Path testSourcePath) {
        ArrayList<SymbolicLinkDefinition> links = new ArrayList<SymbolicLinkDefinition>();
        try (Stream<String> stream = Files.lines(manifestPath);){
            Iterator it = stream.iterator();
            int lineNumber = 0;
            while (it.hasNext()) {
                ++lineNumber;
                String line = (String)it.next();
                String[] splitLine = line.split(" ");
                if (splitLine.length != 2) {
                    logger.warning("Skipping runfile line %d because the format is invalid (%d elements instead of exactly 2).", new Object[]{lineNumber, splitLine.length});
                    continue;
                }
                links.add(new SymbolicLinkDefinition(testSourcePath.resolve(splitLine[0]), Paths.get(splitLine[1], new String[0])));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading bazel MANIFEST file", e);
        }
        return links;
    }
}

