/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils;

import com.google.common.base.Preconditions;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public final class TestResources {
    private TestResources() {
    }

    public static File getFile(String name) {
        Preconditions.checkArgument((boolean)name.startsWith("/"), (String)"'%s' is not an absolute path.", (Object)name);
        return TestResources.getFile(TestResources.class, name);
    }

    public static File getFile(Class<?> clazz, String name) {
        URL url = Resources.getResource(clazz, (String)name);
        if (!url.getPath().contains("jar!")) {
            return new File(url.getFile());
        }
        try {
            File tempDir = Files.createTempDir();
            File tempFile = new File(tempDir, name);
            tempFile.deleteOnExit();
            tempDir.deleteOnExit();
            Files.createParentDirs((File)tempFile);
            Resources.asByteSource((URL)url).copyTo(Files.asByteSink((File)tempFile, (FileWriteMode[])new FileWriteMode[0]));
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void getFileInDirectory(Class<?> clazz, String resourceName, String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return;
        }
        URL url = Resources.getResource(clazz, (String)resourceName);
        file.getParentFile().mkdirs();
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            Resources.copy((URL)url, (OutputStream)outputStream);
            file.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getDirectory(String name) {
        Preconditions.checkArgument((boolean)name.startsWith("/"), (String)"'%s' is not an absolute path.", (Object)name);
        return TestResources.getDirectory(TestResources.class, name);
    }

    public static File getDirectory(Class<?> clazz, String path) {
        URL dirURL = Resources.getResource(clazz, (String)path);
        switch (dirURL.getProtocol()) {
            case "file": {
                return new File(dirURL.getFile());
            }
            case "jar": {
                return TestResources.getDirectoryFromJar(dirURL);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported protocol %s to get class %s resource directory %s", dirURL.getProtocol(), clazz.getName(), path));
    }

    private static File getDirectoryFromJar(URL jarDirUrl) {
        JarFile jar;
        String dirEntryName;
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)jarDirUrl.openConnection();
            dirEntryName = jarURLConnection.getEntryName();
            jar = jarURLConnection.getJarFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File root = TestResources.getTempRoot();
        jar.stream().forEach(jarEntry -> {
            if (jarEntry.getName().startsWith(dirEntryName) && !jarEntry.isDirectory()) {
                File file = new File(root, jarEntry.getName());
                file.getParentFile().mkdirs();
                try (InputStream inputStream = jar.getInputStream((ZipEntry)jarEntry);){
                    Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).writeFrom(inputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                file.deleteOnExit();
            }
        });
        return new File(root, dirEntryName);
    }

    private static File getTempRoot() {
        File tempFile;
        try {
            tempFile = File.createTempFile("temp", null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File root = tempFile.getParentFile();
        tempFile.delete();
        return root;
    }
}

