/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.filesystemdiff;

import com.android.testutils.filesystemdiff.Action;
import com.android.testutils.filesystemdiff.CreateFileAction;
import com.android.testutils.filesystemdiff.CreateSymbolicLinkAction;
import com.android.testutils.filesystemdiff.DirectoryEntry;
import com.android.testutils.filesystemdiff.FileEntry;
import com.android.testutils.filesystemdiff.FileSystemEntry;
import com.android.testutils.filesystemdiff.SymbolicLinkEntry;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class CreateDirectoryAction
extends Action {
    private DirectoryEntry mSource;
    private DirectoryEntry mDestination;

    public CreateDirectoryAction(DirectoryEntry source, DirectoryEntry destination) {
        this.mSource = source;
        this.mDestination = destination;
    }

    @Override
    public DirectoryEntry getSourceEntry() {
        return this.mSource;
    }

    @Override
    public void execute(ILogger logger) {
        logger.verbose("Creating directory %s", new Object[]{this.mDestination.getPath()});
        try {
            Files.createDirectory(this.mDestination.getPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        block7: for (FileSystemEntry child : this.mSource.getChildEntries()) {
            Path destinationPath = this.mDestination.getPath().resolve(child.getPath().getFileName());
            switch (child.getKind()) {
                case Directory: {
                    FileSystemEntry dest = new DirectoryEntry(destinationPath);
                    new CreateDirectoryAction((DirectoryEntry)child, (DirectoryEntry)dest).execute(logger);
                    continue block7;
                }
                case SymbolicLink: {
                    FileSystemEntry dest = new SymbolicLinkEntry(destinationPath, ((SymbolicLinkEntry)child).getTarget());
                    new CreateSymbolicLinkAction((SymbolicLinkEntry)child, (SymbolicLinkEntry)dest).execute(logger);
                    continue block7;
                }
                case File: {
                    FileSystemEntry dest = new FileEntry(destinationPath);
                    new CreateFileAction((FileEntry)child, (FileEntry)dest).execute(logger);
                    continue block7;
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

