/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.filesystemdiff;

import com.android.testutils.filesystemdiff.Action;
import com.android.testutils.filesystemdiff.SymbolicLinkEntry;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class CreateSymbolicLinkAction
extends Action {
    private SymbolicLinkEntry mSource;
    private SymbolicLinkEntry mDestination;

    public CreateSymbolicLinkAction(SymbolicLinkEntry source, SymbolicLinkEntry destination) {
        this.mSource = source;
        this.mDestination = destination;
    }

    @Override
    public SymbolicLinkEntry getSourceEntry() {
        return this.mSource;
    }

    @Override
    public void execute(ILogger logger) {
        try {
            logger.verbose("Creating symbolic link \"%s\" pointing to target \"%s\"", new Object[]{this.mDestination.getPath(), this.mDestination.getTarget()});
            Files.createDirectories(this.mDestination.getPath().getParent(), new FileAttribute[0]);
            Files.createSymbolicLink(this.mDestination.getPath(), this.mDestination.getTarget(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating symbolic link", e);
        }
    }
}

