/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.truth;

import com.android.testutils.apk.Dex;
import com.android.testutils.truth.DexClassSubject;
import com.android.testutils.truth.IndirectSubject;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;

public class DexSubject
extends Subject<DexSubject, Dex> {
    public static final SubjectFactory<DexSubject, Dex> FACTORY = new SubjectFactory<DexSubject, Dex>(){

        public DexSubject getSubject(FailureStrategy fs, Dex that) {
            return new DexSubject(fs, that);
        }
    };

    private DexSubject(FailureStrategy fs, Dex that) {
        super(fs, (Object)that);
    }

    public static DexSubject assertThat(Dex dex) {
        return (DexSubject)Truth.assert_().about(FACTORY).that((Object)dex);
    }

    public static DexSubject assertThatDex(File dex) {
        return DexSubject.assertThat(dex != null ? new Dex(dex.toPath()) : null);
    }

    public IndirectSubject<DexClassSubject> containsClass(String className) throws IOException {
        DexSubject.checkClassName(className);
        if (this.assertSubjectIsNonNull()) {
            DexBackedClassDef classDef = (DexBackedClassDef)((Dex)this.getSubject()).getClasses().get((Object)className);
            if (classDef == null) {
                this.fail("contains class", className);
            }
            return () -> (DexClassSubject)DexClassSubject.FACTORY.getSubject(this.failureStrategy, (Object)classDef);
        }
        return () -> (DexClassSubject)DexClassSubject.FACTORY.getSubject(this.failureStrategy, null);
    }

    public void containsClassesIn(Iterable<String> expected) throws IOException {
        Sets.SetView missing;
        for (String clazz : expected) {
            DexSubject.checkClassName(clazz);
        }
        if (this.assertSubjectIsNonNull() && !(missing = Sets.difference((Set)ImmutableSet.copyOf(expected), (Set)((Dex)this.getSubject()).getClasses().keySet())).isEmpty()) {
            this.failWithBadResults("contains classes", Iterables.toString(expected), "is missing", missing);
        }
    }

    public void containsExactlyClassesIn(Iterable<String> expected) throws IOException {
        for (String clazz : expected) {
            DexSubject.checkClassName(clazz);
        }
        if (this.assertSubjectIsNonNull()) {
            Sets.SetView missing = Sets.difference((Set)ImmutableSet.copyOf(expected), (Set)((Dex)this.getSubject()).getClasses().keySet());
            Sets.SetView unexpectedElements = Sets.difference((Set)((Dex)this.getSubject()).getClasses().keySet(), (Set)ImmutableSet.copyOf(expected));
            if (!missing.isEmpty()) {
                if (!unexpectedElements.isEmpty()) {
                    this.failWithRawMessage("Not true that %s %s <%s>. It is missing <%s> and has unexpected items <%s>", new Object[]{this.getDisplaySubject(), "contains exactly", expected, Iterables.toString((Iterable)missing), Iterables.toString((Iterable)unexpectedElements)});
                } else {
                    this.failWithBadResults("contains exactly classes", Iterables.toString(expected), "is missing", missing);
                }
            }
            if (!unexpectedElements.isEmpty()) {
                this.failWithBadResults("contains exactly classes", Iterables.toString(expected), "has unexpected", unexpectedElements);
            }
        }
    }

    public void containsClasses(String ... expected) throws IOException {
        this.containsClassesIn(Sets.newHashSet((Object[])expected));
    }

    public void doesNotContainClasses(String ... unexpected) throws IOException {
        Sets.SetView present;
        for (String clazz : unexpected) {
            DexSubject.checkClassName(clazz);
        }
        if (this.assertSubjectIsNonNull() && !(present = Sets.intersection((Set)ImmutableSet.copyOf((Object[])unexpected), (Set)((Dex)this.getSubject()).getClasses().keySet())).isEmpty()) {
            this.failWithBadResults("does not contains classes", Arrays.toString(unexpected), "contains", present);
        }
    }

    public void hasClassesCount(int expected) throws IOException {
        if (expected != ((Dex)this.getSubject()).getClasses().size()) {
            this.failWithBadResults("does not have size", expected, "has", ((Dex)this.getSubject()).getClasses().size());
        }
    }

    protected String getDisplaySubject() {
        return "dex file";
    }

    private boolean assertSubjectIsNonNull() {
        if (this.getSubject() == null) {
            this.failWithRawMessage("Cannot assert about the contents of a dex file that does not exist.", new Object[0]);
            return false;
        }
        return true;
    }

    private static void checkClassName(String className) {
        Preconditions.checkArgument((className.startsWith("L") && className.endsWith(";") ? 1 : 0) != 0, (String)"Class name '%s' must be in the type descriptor format, e.g. Lcom/foo/Main;", (Object)className);
    }
}

