/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.truth;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;

public final class DexUtils {
    private static final Opcodes DEX_LIB_OPCODES = Opcodes.forApi((int)24);

    private DexUtils() {
    }

    public static DexBackedDexFile loadDex(byte[] bytes) {
        return new DexBackedDexFile(DEX_LIB_OPCODES, bytes);
    }

    public static DexBackedDexFile loadDex(Path path) throws IOException {
        return DexUtils.loadDex(Files.readAllBytes(path));
    }

    public static DexBackedDexFile loadDex(File file) throws IOException {
        return DexUtils.loadDex(file.toPath());
    }

    public static DexBackedClassDef getClass(DexBackedDexFile dex, String name) {
        return dex != null ? DexUtils.getClass(Collections.singleton(dex), name) : null;
    }

    public static DexBackedClassDef getClass(Collection<DexBackedDexFile> dexFiles, String name) {
        for (DexBackedDexFile dexFile : dexFiles) {
            Optional<DexBackedClassDef> classDef = dexFile.getClasses().parallelStream().filter(clazz -> clazz.getType().equals(name)).findAny();
            if (!classDef.isPresent()) continue;
            return classDef.get();
        }
        return null;
    }
}

