/*
 * Decompiled with CFR 0.152.
 */
package com.android.testutils.truth;

import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class FileSubject
extends Subject<FileSubject, File> {
    public static final SubjectFactory<FileSubject, File> FACTORY = new SubjectFactory<FileSubject, File>(){

        public FileSubject getSubject(FailureStrategy fs, File that) {
            return new FileSubject(fs, that);
        }
    };

    public FileSubject(FailureStrategy failureStrategy, File subject) {
        super(failureStrategy, (Object)subject);
    }

    public static FileSubject assertThat(File file) {
        return (FileSubject)Truth.assert_().about(FACTORY).that((Object)file);
    }

    public void hasName(String name) {
        ((StringSubject)this.check().that(((File)this.getSubject()).getName()).named(this.getDisplaySubject())).isEqualTo((Object)name);
    }

    public void exists() {
        if (!((File)this.getSubject()).exists()) {
            this.fail("exists");
        }
    }

    public void doesNotExist() {
        if (((File)this.getSubject()).exists()) {
            this.fail("does not exist");
        }
    }

    public void isFile() {
        if (!((File)this.getSubject()).isFile()) {
            this.fail("is a file");
        }
    }

    public void isDirectory() {
        if (!((File)this.getSubject()).isDirectory()) {
            this.fail("is a directory");
        }
    }

    public void contains(String expectedContent) {
        this.containsAllOf(expectedContent);
    }

    public void containsAllOf(String ... expectedContents) {
        this.isFile();
        try {
            String contents = Files.toString((File)((File)this.getSubject()), (Charset)Charsets.UTF_8);
            for (String expectedContent : expectedContents) {
                if (contents.contains(expectedContent)) continue;
                this.failWithBadResults("contains", expectedContent, "is", contents);
            }
        }
        catch (IOException e) {
            this.failWithRawMessage("Unable to read %s", new Object[]{this.getSubject()});
        }
    }

    public void contains(byte[] expectedContents) {
        this.isFile();
        try {
            byte[] contents = Files.toByteArray((File)((File)this.getSubject()));
            if (!Arrays.equals(contents, expectedContents)) {
                this.failWithBadResults("contains", "byte[" + expectedContents.length + "]", "is", "byte[" + contents.length + "]");
            }
        }
        catch (IOException e) {
            this.failWithRawMessage("Unable to read %s", new Object[]{this.getSubject()});
        }
    }

    public void doesNotContain(String expectedContent) {
        this.isFile();
        try {
            String contents = Files.toString((File)((File)this.getSubject()), (Charset)Charsets.UTF_8);
            if (contents.contains(expectedContent)) {
                this.failWithBadResults("does not contains", expectedContent, "is", contents);
            }
        }
        catch (IOException e) {
            this.failWithRawMessage("Unable to read %s", new Object[]{this.getSubject()});
        }
    }

    public void hasContents(String expectedContents) {
        this.contains(expectedContents.getBytes(Charsets.UTF_8));
    }

    public void wasModifiedAt(long timestamp) {
        long lastModified = ((File)this.getSubject()).lastModified();
        if (((File)this.getSubject()).lastModified() != timestamp) {
            this.failWithBadResults("was not modified at", timestamp, "was modified at", lastModified);
        }
    }

    public void isNewerThan(long timestamp) {
        long lastModified = ((File)this.getSubject()).lastModified();
        if (((File)this.getSubject()).lastModified() <= timestamp) {
            this.failWithBadResults("is newer than", timestamp, "was modified at", lastModified);
        }
    }

    public void isNewerThan(File other) {
        this.isNewerThan(other.lastModified());
    }

    public void isNewerThanOrSameAs(long otherTimestamp) {
        long thisTimestamp = ((File)this.getSubject()).lastModified();
        if (((File)this.getSubject()).lastModified() < otherTimestamp) {
            this.failWithBadResults("is newer than or same as", otherTimestamp, "was modified at", thisTimestamp);
        }
    }

    public void isNewerThanOrSameAs(File other) {
        this.isNewerThanOrSameAs(other.lastModified());
    }

    public void contentWithUnixLineSeparatorsIsExactly(String expected) throws IOException {
        String actual = FileUtils.loadFileWithUnixLineSeparators((File)((File)this.getSubject()));
        new StringSubject(this.failureStrategy, actual).isEqualTo((Object)expected);
    }

    public void containsFile(String fileName) {
        this.isDirectory();
        if (!FileUtils.find((File)((File)this.getSubject()), (String)fileName).isPresent()) {
            this.fail("Directory ", new Object[]{this.getSubject(), " does not contain ", fileName});
        }
    }

    public void doesNotContainFile(String fileName) {
        this.isDirectory();
        if (FileUtils.find((File)((File)this.getSubject()), (String)fileName).isPresent()) {
            this.fail("Directory ", new Object[]{this.getSubject(), " contains ", fileName});
        }
    }
}

