/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.deviceprovider.gradle;

import com.android.tools.utp.plugins.deviceprovider.gradle.EmulatorHandle;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.lib.process.Handle;
import com.google.testing.platform.lib.process.inject.SubprocessComponent;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\rH\u0016J(\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/utp/plugins/deviceprovider/gradle/EmulatorHandleImpl;", "Lcom/android/tools/utp/plugins/deviceprovider/gradle/EmulatorHandle;", "subprocessComponent", "Lcom/google/testing/platform/lib/process/inject/SubprocessComponent;", "(Lcom/google/testing/platform/lib/process/inject/SubprocessComponent;)V", "emulatorGpuFlag", "", "emulatorPath", "logger", "Ljava/util/logging/Logger;", "processHandle", "Lcom/google/testing/platform/lib/process/Handle;", "showEmulatorKernelLogging", "", "closeInstance", "", "configure", "exitCode", "", "()Ljava/lang/Integer;", "isAlive", "launchInstance", "avdName", "avdFolder", "avdId", "enableDisplay", "Companion", "android-device-provider-gradle"})
public final class EmulatorHandleImpl
implements EmulatorHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SubprocessComponent subprocessComponent;
    @NotNull
    private final Logger logger;
    private String emulatorPath;
    private String emulatorGpuFlag;
    private boolean showEmulatorKernelLogging;
    @Nullable
    private Handle processHandle;
    @NotNull
    private static final String EMULATOR_NO_WINDOW = "-no-window";
    @NotNull
    private static final String EMULATOR_GPU = "-gpu";
    @NotNull
    private static final String EMULATOR_NO_AUDIO = "-no-audio";
    @NotNull
    private static final String EMULATOR_NO_BOOT_ANIM = "-no-boot-anim";
    @NotNull
    private static final String EMULATOR_READ_ONLY = "-read-only";
    @NotNull
    private static final String EMULATOR_NO_SNAPSHOT_SAVE = "-no-snapshot-save";
    @NotNull
    private static final String EMULATOR_VERBOSE = "-verbose";
    @NotNull
    private static final String EMULATOR_SHOW_KERNEL = "-show-kernel";
    @NotNull
    private static final String EMULATOR_DELAY_ADB = "-delay-adb";

    public EmulatorHandleImpl(@NotNull SubprocessComponent subprocessComponent) {
        Intrinsics.checkNotNullParameter((Object)subprocessComponent, (String)"subprocessComponent");
        this.subprocessComponent = subprocessComponent;
        this.logger = LoggerExtKt.getLogger((Object)this);
    }

    @Override
    public void configure(@NotNull String emulatorPath, @NotNull String emulatorGpuFlag, boolean showEmulatorKernelLogging) {
        Intrinsics.checkNotNullParameter((Object)emulatorPath, (String)"emulatorPath");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        this.emulatorPath = emulatorPath;
        this.emulatorGpuFlag = emulatorGpuFlag;
        this.showEmulatorKernelLogging = showEmulatorKernelLogging;
    }

    @Override
    public boolean isAlive() {
        Handle handle = this.processHandle;
        return handle != null ? handle.isAlive() : false;
    }

    @Override
    @Nullable
    public Integer exitCode() {
        Handle handle = this.processHandle;
        return handle != null ? Integer.valueOf(handle.exitCode()) : null;
    }

    @Override
    public void launchInstance(@NotNull String avdName, @NotNull String avdFolder, @NotNull String avdId, boolean enableDisplay) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkNotNullParameter((Object)avdId, (String)"avdId");
        Object[] objectArray = new String[1];
        String string = this.emulatorPath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emulatorPath");
            string = null;
        }
        objectArray[0] = string;
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        args.add("@" + avdName);
        if (!enableDisplay) {
            args.add(EMULATOR_NO_WINDOW);
            args.add(EMULATOR_NO_AUDIO);
        }
        args.add(EMULATOR_GPU);
        String string2 = this.emulatorGpuFlag;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emulatorGpuFlag");
            string2 = null;
        }
        args.add(string2);
        args.add(EMULATOR_READ_ONLY);
        args.add(EMULATOR_NO_SNAPSHOT_SAVE);
        args.add(EMULATOR_NO_BOOT_ANIM);
        args.add(EMULATOR_DELAY_ADB);
        if (this.showEmulatorKernelLogging) {
            args.add(EMULATOR_VERBOSE);
            args.add(EMULATOR_SHOW_KERNEL);
        }
        args.add("-id");
        args.add(avdId);
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv()");
        Map emulatorEnvironment = MapsKt.toMutableMap(map);
        emulatorEnvironment.put("ANDROID_AVD_HOME", avdFolder);
        Handle handle = this.processHandle;
        if (handle != null) {
            handle.destroy();
        }
        this.processHandle = this.subprocessComponent.subprocess().executeAsync(args, emulatorEnvironment, (Function1)new Function1<String, Unit>((Object)this.logger){

            public final void invoke(String p0) {
                ((Logger)this.receiver).info(p0);
            }
        }, (Function1)new Function1<String, Unit>((Object)this.logger){

            public final void invoke(String p0) {
                ((Logger)this.receiver).info(p0);
            }
        });
    }

    @Override
    public void closeInstance() {
        block0: {
            Handle handle = this.processHandle;
            if (handle == null) break block0;
            handle.destroy();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/utp/plugins/deviceprovider/gradle/EmulatorHandleImpl$Companion;", "", "()V", "EMULATOR_DELAY_ADB", "", "EMULATOR_GPU", "EMULATOR_NO_AUDIO", "EMULATOR_NO_BOOT_ANIM", "EMULATOR_NO_SNAPSHOT_SAVE", "EMULATOR_NO_WINDOW", "EMULATOR_READ_ONLY", "EMULATOR_SHOW_KERNEL", "EMULATOR_VERBOSE", "android-device-provider-gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

