/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.logcat;

import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.device.CommandHandle;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.plugin.HostPlugin;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\n %*\u0004\u0018\u00010\t0\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\tH\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0015H\u0002J\b\u0010.\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/utp/plugins/host/logcat/AndroidTestLogcatPlugin;", "Lcom/google/testing/platform/api/plugin/HostPlugin;", "logger", "Ljava/util/logging/Logger;", "(Ljava/util/logging/Logger;)V", "logcatCommandHandle", "Lcom/google/testing/platform/api/device/CommandHandle;", "logcatFilePaths", "", "", "logcatOptions", "", "outputDir", "tempLogcatFile", "Ljava/io/File;", "tempLogcatWriter", "Ljava/io/BufferedWriter;", "afterAll", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "testSuiteResult", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "cancelled", "", "afterEach", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "testResult", "beforeAll", "", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "canRun", "configure", "context", "Lcom/google/testing/platform/api/context/Context;", "generateLogcatFileName", "kotlin.jvm.PlatformType", "testPackageAndClass", "testMethod", "getDeviceCurrentTime", "parseLine", "line", "setUpLogcatCommandLine", "startLogcatAsync", "controller", "stopLogcat", "Companion", "android-test-plugin-host-logcat"})
public final class AndroidTestLogcatPlugin
implements HostPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private String outputDir;
    private File tempLogcatFile;
    private BufferedWriter tempLogcatWriter;
    private CommandHandle logcatCommandHandle;
    @NotNull
    private List<String> logcatFilePaths;
    @NotNull
    private List<String> logcatOptions;

    public AndroidTestLogcatPlugin(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf())");
        this.logcatFilePaths = list;
        this.logcatOptions = new ArrayList();
    }

    public /* synthetic */ AndroidTestLogcatPlugin(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = LoggerExtKt.getLogger((Object)Companion);
        }
        this(logger);
    }

    public void configure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.get("config");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.testing.platform.api.config.Config");
        Config config = (Config)object;
        this.outputDir = ConfigExtKt.getEnvironment((Config)config).getOutputDirectory();
    }

    public void beforeAll(@NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.logger.fine("Start logcat streaming.");
        this.logcatCommandHandle = this.startLogcatAsync(deviceController);
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public TestResultProto.TestResult afterEach(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController, boolean cancelled) {
        TestResultProto.TestResult.Builder builder;
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        TestCaseProto.TestCase testCase = testResult.getTestCase();
        String packageName = testCase.getTestPackage();
        String className = testCase.getTestClass();
        String methodName = testCase.getTestMethod();
        TestResultProto.TestResult.Builder $this$afterEach_u24lambda_u2d3 = builder = testResult.toBuilder();
        boolean bl = false;
        List<String> list = this.logcatFilePaths;
        synchronized (list) {
            boolean bl2 = false;
            Iterable $this$forEach$iv = this.logcatFilePaths;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$afterEach_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0;
                TestArtifactProto.Artifact.Builder builder2;
                String it = (String)element$iv;
                boolean bl3 = false;
                String string = packageName + "." + className;
                Intrinsics.checkNotNullExpressionValue((Object)methodName, (String)"methodName");
                if (!Intrinsics.areEqual((Object)it, (Object)this.generateLogcatFileName(string, methodName))) continue;
                TestArtifactProto.Artifact.Builder builder3 = builder2 = TestArtifactProto.Artifact.newBuilder();
                TestResultProto.TestResult.Builder builder4 = $this$afterEach_u24lambda_u2d3;
                boolean bl4 = false;
                $this$afterEach_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getLabelBuilder().setLabel("logcat");
                $this$afterEach_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getLabelBuilder().setNamespace("android");
                $this$afterEach_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getSourcePathBuilder().setPath(it);
                builder4.addOutputArtifact(builder2.build());
            }
            Unit unit = Unit.INSTANCE;
        }
        TestResultProto.TestResult updatedTestResult = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)updatedTestResult, (String)"updatedTestResult");
        return updatedTestResult;
    }

    @NotNull
    public TestSuiteResultProto.TestSuiteResult afterAll(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.stopLogcat();
        return testSuiteResult;
    }

    public boolean canRun() {
        return true;
    }

    private final String generateLogcatFileName(String testPackageAndClass, String testMethod) {
        String string = this.outputDir;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            string = null;
        }
        return new File(string, "logcat-" + testPackageAndClass + "-" + testMethod + ".txt").getAbsolutePath();
    }

    private final String getDeviceCurrentTime(DeviceController deviceController) {
        Object[] objectArray = new String[]{"date", "+%m-%d\\ %H:%M:%S"};
        CommandResult dateCommandResult = AndroidDeviceControllerExtKt.deviceShell$default((DeviceController)deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
        if (dateCommandResult.getStatusCode() != 0 || dateCommandResult.getOutput().isEmpty()) {
            this.logger.warning("Failed to read device time.");
            return null;
        }
        return "'" + dateCommandResult.getOutput().get(0) + ".000'";
    }

    private final List<String> setUpLogcatCommandLine() {
        List logcatCommand;
        List $this$setUpLogcatCommandLine_u24lambda_u2d4 = logcatCommand = (List)new ArrayList();
        boolean bl = false;
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("shell");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("logcat");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("-v");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("threadtime");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("-b");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.add("main");
        $this$setUpLogcatCommandLine_u24lambda_u2d4.addAll((Collection)this.logcatOptions);
        return logcatCommand;
    }

    private final CommandHandle startLogcatAsync(DeviceController controller) {
        String deviceTime = this.getDeviceCurrentTime(controller);
        if (deviceTime != null) {
            Object[] objectArray = new String[]{"-T", deviceTime};
            this.logcatOptions = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        Ref.BooleanRef testRunInProgress = new Ref.BooleanRef();
        return controller.executeAsync(this.setUpLogcatCommandLine(), (Function1)new Function1<String, Unit>(testRunInProgress, this){
            final /* synthetic */ Ref.BooleanRef $testRunInProgress;
            final /* synthetic */ AndroidTestLogcatPlugin this$0;
            {
                this.$testRunInProgress = $testRunInProgress;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)"TestRunner: started: ", (boolean)false, (int)2, null)) {
                    this.$testRunInProgress.element = true;
                    AndroidTestLogcatPlugin.access$parseLine(this.this$0, line);
                }
                if (this.$testRunInProgress.element) {
                    BufferedWriter bufferedWriter = AndroidTestLogcatPlugin.access$getTempLogcatWriter$p(this.this$0);
                    if (bufferedWriter == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                        bufferedWriter = null;
                    }
                    bufferedWriter.write(line);
                    BufferedWriter bufferedWriter2 = AndroidTestLogcatPlugin.access$getTempLogcatWriter$p(this.this$0);
                    if (bufferedWriter2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                        bufferedWriter2 = null;
                    }
                    bufferedWriter2.newLine();
                    BufferedWriter bufferedWriter3 = AndroidTestLogcatPlugin.access$getTempLogcatWriter$p(this.this$0);
                    if (bufferedWriter3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                        bufferedWriter3 = null;
                    }
                    bufferedWriter3.flush();
                }
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)"TestRunner: finished:", (boolean)false, (int)2, null)) {
                    this.$testRunInProgress.element = false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void stopLogcat() {
        block11: {
            try {
                if (this.logcatCommandHandle != null) {
                    v0 = this.logcatCommandHandle;
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logcatCommandHandle");
                        v0 = null;
                    }
                    v0.stop();
                    v1 = this.logcatCommandHandle;
                    if (v1 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logcatCommandHandle");
                        v1 = null;
                    }
                    CommandHandle.waitFor$default((CommandHandle)v1, null, (int)1, null);
                }
                if (this.tempLogcatWriter == null) break block11;
                v2 = this.tempLogcatWriter;
                ** if (v2 != null) goto lbl19
            }
            catch (Throwable t) {
                try {
                    this.logger.warning("Stopping logcat failed with the following error: " + t);
                    if (this.tempLogcatWriter == null) break block11;
                    v3 = this.tempLogcatWriter;
                    ** if (v3 != null) goto lbl37
                }
                catch (Throwable var1_2) {
                    if (this.tempLogcatWriter != null) {
                        v4 = this.tempLogcatWriter;
                        if (v4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                            v4 = null;
                        }
                        v4.close();
                    }
                    throw var1_2;
                }
lbl-1000:
                // 1 sources

                {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                    v3 = null;
                }
lbl37:
                // 2 sources

                v3.close();
            }
lbl-1000:
            // 1 sources

            {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatWriter");
                v2 = null;
            }
lbl19:
            // 2 sources

            v2.close();
        }
    }

    private final void parseLine(String line) {
        String[] stringArray = new String[]{"TestRunner: started: "};
        CharSequence charSequence = (CharSequence)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
        stringArray = new String[]{"("};
        List testPackageClassAndMethodNames = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String testMethod = ((Object)StringsKt.trim((CharSequence)((String)testPackageClassAndMethodNames.get(0)))).toString();
        String testPackageAndClass = StringsKt.removeSuffix((String)((String)testPackageClassAndMethodNames.get(1)), (CharSequence)")");
        String tempFileName = this.generateLogcatFileName(testPackageAndClass, testMethod);
        this.tempLogcatFile = new File(tempFileName);
        Intrinsics.checkNotNullExpressionValue((Object)tempFileName, (String)"tempFileName");
        this.logcatFilePaths.add(tempFileName);
        File file = this.tempLogcatFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tempLogcatFile");
            file = null;
        }
        Object object = file;
        object = new FileOutputStream((File)object);
        Charset charset = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)object, charset);
        int n = 8192;
        this.tempLogcatWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
    }

    public AndroidTestLogcatPlugin() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$parseLine(AndroidTestLogcatPlugin $this, String line) {
        $this.parseLine(line);
    }

    public static final /* synthetic */ BufferedWriter access$getTempLogcatWriter$p(AndroidTestLogcatPlugin $this) {
        return $this.tempLogcatWriter;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/tools/utp/plugins/host/logcat/AndroidTestLogcatPlugin$Companion;", "", "()V", "android-test-plugin-host-logcat"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

