/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.icebox;

import com.android.emulator.control.IceboxTarget;
import com.android.emulator.control.SnapshotPackage;
import com.android.emulator.control.SnapshotServiceGrpc;
import com.android.tools.utp.plugins.host.icebox.IceboxCaller;
import com.android.tools.utp.plugins.host.icebox.IceboxCallerImpl;
import com.android.tools.utp.plugins.host.icebox.IceboxCallerImplKt;
import com.android.tools.utp.plugins.host.icebox.LogcatParser;
import com.android.tools.utp.plugins.host.icebox.proto.IceboxPluginProto;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0003 !\"B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J0\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/utp/plugins/host/icebox/IceboxCallerImpl;", "Lcom/android/tools/utp/plugins/host/icebox/IceboxCaller;", "managedChannelBuilder", "Lio/grpc/ManagedChannelBuilder;", "grpcToken", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lio/grpc/ManagedChannelBuilder;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;)V", "logcatParser", "Lcom/android/tools/utp/plugins/host/icebox/LogcatParser;", "managedChannel", "Lio/grpc/ManagedChannel;", "snapshotService", "Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceBlockingStub;", "fetchSnapshot", "", "snapshotFile", "Ljava/io/File;", "snapshotCompression", "Lcom/android/tools/utp/plugins/host/icebox/proto/IceboxPluginProto$Compression;", "emulatorSnapshotId", "runIcebox", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "testedApplicationID", "snapshotNamePrefix", "maxSnapshotNumber", "", "androidStudioDdmlibPort", "setupGrpc", "shutdownGrpc", "Companion", "IceboxException", "TokenCallCredentials", "android-test-plugin-host-retention"})
public final class IceboxCallerImpl
implements IceboxCaller {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ManagedChannelBuilder<?> managedChannelBuilder;
    @NotNull
    private final String grpcToken;
    @NotNull
    private final CoroutineScope coroutineScope;
    private SnapshotServiceGrpc.SnapshotServiceBlockingStub snapshotService;
    private ManagedChannel managedChannel;
    @NotNull
    private final LogcatParser logcatParser;
    @Deprecated
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger((Object)Companion);

    public IceboxCallerImpl(@NotNull ManagedChannelBuilder<?> managedChannelBuilder, @NotNull String grpcToken, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(managedChannelBuilder, (String)"managedChannelBuilder");
        Intrinsics.checkNotNullParameter((Object)grpcToken, (String)"grpcToken");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.managedChannelBuilder = managedChannelBuilder;
        this.grpcToken = grpcToken;
        this.coroutineScope = coroutineScope;
        this.logcatParser = new LogcatParser();
        this.setupGrpc();
    }

    private final void setupGrpc() {
        try {
            ManagedChannel managedChannel = this.managedChannelBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"managedChannelBuilder.build()");
            this.managedChannel = managedChannel;
            if (Intrinsics.areEqual((Object)this.grpcToken, (Object)"")) {
                ManagedChannel managedChannel2 = this.managedChannel;
                if (managedChannel2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"managedChannel");
                    managedChannel2 = null;
                }
                SnapshotServiceGrpc.SnapshotServiceBlockingStub snapshotServiceBlockingStub = SnapshotServiceGrpc.newBlockingStub((Channel)((Channel)managedChannel2));
                Intrinsics.checkNotNullExpressionValue((Object)snapshotServiceBlockingStub, (String)"newBlockingStub(managedChannel)");
                this.snapshotService = snapshotServiceBlockingStub;
            } else {
                TokenCallCredentials credentials = new TokenCallCredentials(this.grpcToken);
                ManagedChannel managedChannel3 = this.managedChannel;
                if (managedChannel3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"managedChannel");
                    managedChannel3 = null;
                }
                AbstractStub abstractStub = SnapshotServiceGrpc.newBlockingStub((Channel)((Channel)managedChannel3)).withCallCredentials((CallCredentials)credentials);
                Intrinsics.checkNotNullExpressionValue((Object)abstractStub, (String)"newBlockingStub(managedC\u2026lCredentials(credentials)");
                this.snapshotService = (SnapshotServiceGrpc.SnapshotServiceBlockingStub)abstractStub;
            }
        }
        catch (Throwable e) {
            logger.severe("icebox grpc failed: " + e + ". Please try to update the emulator to the latest version, or append the flag \"-grpc 8554\" when booting the emulator.");
            this.shutdownGrpc();
        }
    }

    @Override
    public void runIcebox(@NotNull DeviceController deviceController, @NotNull String testedApplicationID, @NotNull String snapshotNamePrefix, int maxSnapshotNumber, int androidStudioDdmlibPort) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        Intrinsics.checkNotNullParameter((Object)testedApplicationID, (String)"testedApplicationID");
        Intrinsics.checkNotNullParameter((Object)snapshotNamePrefix, (String)"snapshotNamePrefix");
        this.logcatParser.start(deviceController, (Function7<? super String, ? super String, ? super String, ? super String, ? super String, ? super String, ? super String, Unit>)((Function7)new Function7<String, String, String, String, String, String, String, Unit>(deviceController, testedApplicationID, androidStudioDdmlibPort, this, snapshotNamePrefix, maxSnapshotNumber){
            final /* synthetic */ DeviceController $deviceController;
            final /* synthetic */ String $testedApplicationID;
            final /* synthetic */ int $androidStudioDdmlibPort;
            final /* synthetic */ IceboxCallerImpl this$0;
            final /* synthetic */ String $snapshotNamePrefix;
            final /* synthetic */ int $maxSnapshotNumber;
            {
                this.$deviceController = $deviceController;
                this.$testedApplicationID = $testedApplicationID;
                this.$androidStudioDdmlibPort = $androidStudioDdmlibPort;
                this.this$0 = $receiver;
                this.$snapshotNamePrefix = $snapshotNamePrefix;
                this.$maxSnapshotNumber = $maxSnapshotNumber;
                super(7);
            }

            public final void invoke(@NotNull String date, @NotNull String time, @NotNull String pid, @NotNull String uid, @NotNull String verbose, @NotNull String tag, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)date, (String)"date");
                Intrinsics.checkNotNullParameter((Object)time, (String)"time");
                Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
                Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
                Intrinsics.checkNotNullParameter((Object)verbose, (String)"verbose");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Waiting for debugger to connect", (boolean)false, (int)2, null)) {
                    String target_pid;
                    Object[] objectArray = new String[]{"pidof", this.$testedApplicationID};
                    CommandResult result = AndroidDeviceControllerExtKt.deviceShell$default((DeviceController)this.$deviceController, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null);
                    String string = (String)CollectionsKt.firstOrNull((List)result.getOutput());
                    String string2 = target_pid = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                    if (Intrinsics.areEqual((Object)target_pid, (Object)pid)) {
                        long pid_long = Long.parseLong(pid);
                        IceboxCallerImplKt.notifyAndroidStudio(this.$deviceController.getDevice().getSerial(), pid_long, this.$androidStudioDdmlibPort, IceboxCallerImpl.access$getCompanion$p().getLogger());
                        SnapshotServiceGrpc.SnapshotServiceBlockingStub snapshotServiceBlockingStub = IceboxCallerImpl.access$getSnapshotService$p(this.this$0);
                        if (snapshotServiceBlockingStub == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"snapshotService");
                            snapshotServiceBlockingStub = null;
                        }
                        IceboxTarget it = snapshotServiceBlockingStub.trackProcess(IceboxTarget.newBuilder().setPid(pid_long).setSnapshotId(this.$snapshotNamePrefix).setMaxSnapshotNumber(this.$maxSnapshotNumber).build());
                        boolean bl = false;
                        if (it.getFailed()) {
                            IceboxCallerImpl.access$getCompanion$p().getLogger().warning("Icebox failed: " + it + ".err");
                        }
                    }
                }
            }
        }));
    }

    @Override
    public void fetchSnapshot(@NotNull File snapshotFile, @NotNull IceboxPluginProto.Compression snapshotCompression, @NotNull String emulatorSnapshotId) {
        Intrinsics.checkNotNullParameter((Object)snapshotFile, (String)"snapshotFile");
        Intrinsics.checkNotNullParameter((Object)snapshotCompression, (String)"snapshotCompression");
        Intrinsics.checkNotNullParameter((Object)emulatorSnapshotId, (String)"emulatorSnapshotId");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, snapshotCompression, snapshotFile, emulatorSnapshotId, null){
            int label;
            final /* synthetic */ IceboxCallerImpl this$0;
            final /* synthetic */ IceboxPluginProto.Compression $snapshotCompression;
            final /* synthetic */ File $snapshotFile;
            final /* synthetic */ String $emulatorSnapshotId;
            {
                this.this$0 = $receiver;
                this.$snapshotCompression = $snapshotCompression;
                this.$snapshotFile = $snapshotFile;
                this.$emulatorSnapshotId = $emulatorSnapshotId;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        IceboxCallerImpl.access$getLogcatParser$p(this.this$0).stop();
                        try {
                            SnapshotServiceGrpc.SnapshotServiceBlockingStub snapshotServiceBlockingStub;
                            Object object2;
                            long l;
                            SnapshotPackage.Format format;
                            switch (fetchSnapshot.WhenMappings.$EnumSwitchMapping$0[this.$snapshotCompression.ordinal()]) {
                                case 1: {
                                    format = SnapshotPackage.Format.DIRECTORY;
                                    break;
                                }
                                case 2: {
                                    format = SnapshotPackage.Format.TARGZ;
                                    break;
                                }
                                case 3: {
                                    format = SnapshotPackage.Format.DIRECTORY;
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            SnapshotPackage.Format snapshotFormat = format;
                            IceboxCallerImpl.access$getCompanion$p().getLogger().info("Pulling snapshot " + this.$snapshotFile.getName() + " from device. This may take a while.");
                            Ref.ObjectRef responses = new Ref.ObjectRef();
                            IceboxCallerImpl iceboxCallerImpl = this.this$0;
                            String string = this.$emulatorSnapshotId;
                            Object object3 = this.$snapshotFile;
                            boolean $i$f$measureTimeMillis = false;
                            long start$iv = System.currentTimeMillis();
                            boolean bl = false;
                            SnapshotServiceGrpc.SnapshotServiceBlockingStub snapshotServiceBlockingStub2 = IceboxCallerImpl.access$getSnapshotService$p(iceboxCallerImpl);
                            if (snapshotServiceBlockingStub2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"snapshotService");
                                snapshotServiceBlockingStub2 = null;
                            }
                            Iterator iterator = snapshotServiceBlockingStub2.pullSnapshot(SnapshotPackage.newBuilder().setSnapshotId(string).setFormat(snapshotFormat).setPath(((File)object3).getAbsolutePath()).build());
                            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"snapshotService.pullSnap\u2026build()\n                )");
                            responses.element = iterator;
                            long it = l = System.currentTimeMillis() - start$iv;
                            boolean bl2 = false;
                            IceboxCallerImpl.access$getCompanion$p().getLogger().info("Pulling snapshot finished, total time " + it / (long)1000 + " seconds.");
                            boolean success = true;
                            OutputStream outputStream = null;
                            if (responses.element == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"responses");
                                object2 = null;
                            } else {
                                object2 = object3 = (Iterator)responses.element;
                            }
                            while (object3.hasNext()) {
                                SnapshotPackage response = (SnapshotPackage)object3.next();
                                if (!response.getSuccess()) {
                                    success = false;
                                    break;
                                }
                                if (response.getPayload().size() <= 0) continue;
                                if (outputStream == null) {
                                    outputStream = new FileOutputStream(this.$snapshotFile);
                                }
                                outputStream.write(response.getPayload().toByteArray());
                            }
                            OutputStream outputStream2 = outputStream;
                            if (outputStream2 != null) {
                                outputStream2.close();
                            }
                            if (!success && this.$snapshotFile.exists()) {
                                this.$snapshotFile.delete();
                            }
                            if ((snapshotServiceBlockingStub = IceboxCallerImpl.access$getSnapshotService$p(this.this$0)) == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"snapshotService");
                                snapshotServiceBlockingStub = null;
                            }
                            Object it2 = object3 = snapshotServiceBlockingStub.deleteSnapshot(SnapshotPackage.newBuilder().setSnapshotId(this.$emulatorSnapshotId).build());
                            boolean bl3 = false;
                            if (!it2.getSuccess()) {
                                IceboxCallerImpl.access$getCompanion$p().getLogger().warning("Icebox failed deleting snapshot!");
                            }
                        }
                        catch (Throwable e) {
                            IceboxCallerImpl.access$getCompanion$p().getLogger().warning("icebox failed: " + e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void shutdownGrpc() {
        ManagedChannel managedChannel;
        try {
            this.logcatParser.stop();
            ManagedChannel managedChannel2 = this.managedChannel;
            if (managedChannel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"managedChannel");
                managedChannel2 = null;
            }
            managedChannel2.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            managedChannel = this.managedChannel;
        }
        catch (Throwable throwable) {
            ManagedChannel managedChannel3 = this.managedChannel;
            if (managedChannel3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"managedChannel");
                managedChannel3 = null;
            }
            managedChannel3.shutdownNow();
            throw throwable;
        }
        ManagedChannel managedChannel4 = managedChannel;
        if (managedChannel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"managedChannel");
            managedChannel4 = null;
        }
        managedChannel4.shutdownNow();
    }

    @NotNull
    public static final Logger getLogger() {
        return Companion.getLogger();
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    public static final /* synthetic */ SnapshotServiceGrpc.SnapshotServiceBlockingStub access$getSnapshotService$p(IceboxCallerImpl $this) {
        return $this.snapshotService;
    }

    public static final /* synthetic */ LogcatParser access$getLogcatParser$p(IceboxCallerImpl $this) {
        return $this.logcatParser;
    }

    @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/utp/plugins/host/icebox/IceboxCallerImpl$IceboxException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "android-test-plugin-host-retention"})
    public static final class IceboxException
    extends Exception {
        public IceboxException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/utp/plugins/host/icebox/IceboxCallerImpl$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "getLogger", "()Ljava/util/logging/Logger;", "android-test-plugin-host-retention"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        public static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/utp/plugins/host/icebox/IceboxCallerImpl$TokenCallCredentials;", "Lio/grpc/CallCredentials;", "token", "", "(Ljava/lang/String;)V", "applyRequestMetadata", "", "requestInfo", "Lio/grpc/CallCredentials$RequestInfo;", "executor", "Ljava/util/concurrent/Executor;", "applier", "Lio/grpc/CallCredentials$MetadataApplier;", "thisUsesUnstableApi", "android-test-plugin-host-retention"})
    private static final class TokenCallCredentials
    extends CallCredentials {
        @NotNull
        private final String token;

        public TokenCallCredentials(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.token = token;
        }

        public void applyRequestMetadata(@NotNull CallCredentials.RequestInfo requestInfo, @NotNull Executor executor, @NotNull CallCredentials.MetadataApplier applier) {
            Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
            executor.execute(new Runnable(this, applier){
                final /* synthetic */ TokenCallCredentials this$0;
                final /* synthetic */ CallCredentials.MetadataApplier $applier;
                {
                    this.this$0 = $receiver;
                    this.$applier = $applier;
                }

                public final void run() {
                    try {
                        Metadata headers = new Metadata();
                        headers.put(IceboxCallerImplKt.access$getAUTHORIZATION_METADATA_KEY$p(), (Object)("Bearer " + TokenCallCredentials.access$getToken$p(this.this$0)));
                        this.$applier.apply(headers);
                    }
                    catch (Throwable e) {
                        IceboxCallerImpl.access$getCompanion$p().getLogger().severe(e.toString());
                        this.$applier.fail(Status.UNAUTHENTICATED.withCause(e));
                    }
                }
            });
        }

        public void thisUsesUnstableApi() {
        }

        public static final /* synthetic */ String access$getToken$p(TokenCallCredentials $this) {
            return $this.token;
        }
    }
}

