/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Crc32;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileSource
extends Source {
    private final File file;
    private ByteBuffer buffer;
    private final int compressionLevel;

    public FileSource(File file, String name, int compressionLevel) {
        super(name);
        this.file = file;
        this.compressionLevel = compressionLevel;
    }

    @Override
    void prepare() throws IOException {
        Path filePath = this.file.toPath();
        byte[] rawBytes = Files.readAllBytes(filePath);
        this.crc = Crc32.crc32(rawBytes);
        this.uncompressedSize = rawBytes.length;
        if (this.compressionLevel == 0) {
            this.buffer = ByteBuffer.wrap(rawBytes);
            this.compressedSize = rawBytes.length;
            this.compressionFlag = 0;
        } else {
            this.buffer = Compressor.deflate(rawBytes, this.compressionLevel);
            this.compressedSize = this.buffer.limit();
            this.compressionFlag = (short)8;
        }
    }

    @Override
    long writeTo(ZipWriter writer) throws IOException {
        return writer.write(this.buffer);
    }
}

