/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Location;
import java.nio.charset.StandardCharsets;

public class Entry {
    private Location location = Location.INVALID;
    private Location cdLocation = Location.INVALID;
    private Location payloadLocation = Location.INVALID;
    private String name = "";
    private int crc;
    private long compressedSize;
    private long uncompressedSize;
    private short compressionFlag;

    Entry() {
    }

    public short getCompressionFlag() {
        return this.compressionFlag;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public String getName() {
        return this.name;
    }

    public int getCrc() {
        return this.crc;
    }

    public boolean isDirectory() {
        return this.name.charAt(this.name.length() - 1) == '/';
    }

    public boolean isCompressed() {
        return this.compressionFlag != 0;
    }

    Location getCdLocation() {
        return this.cdLocation;
    }

    Location getLocation() {
        return this.location;
    }

    Location getPayloadLocation() {
        return this.payloadLocation;
    }

    void setCdLocation(Location cdLocation) {
        this.cdLocation = cdLocation;
    }

    void setNameBytes(byte[] nameBytes) {
        this.name = new String(nameBytes, StandardCharsets.UTF_8);
    }

    void setCrc(int crc) {
        this.crc = crc;
    }

    void setPayloadLocation(Location payloadLocation) {
        this.payloadLocation = payloadLocation;
    }

    void setCompressionFlag(short compressionFlag) {
        this.compressionFlag = compressionFlag;
    }

    void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize;
    }

    void setUncompressedSize(long ucompressedSize) {
        this.uncompressedSize = ucompressedSize;
    }

    void setLocation(Location location) {
        this.location = location;
    }
}

