/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Archive;
import com.android.zipflinger.BytesSource;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;

public class StableArchive
implements Archive {
    private final Archive archive;
    private final ArrayList<BytesSource> bytesSources;
    private final ArrayList<ZipSource> zipSources;
    private final ArrayList<String> deletedEntries;

    public StableArchive(Archive archive) {
        this.archive = archive;
        this.bytesSources = new ArrayList();
        this.zipSources = new ArrayList();
        this.deletedEntries = new ArrayList();
    }

    @Override
    public void add(BytesSource source) {
        this.bytesSources.add(source);
    }

    @Override
    public void add(ZipSource sources) {
        this.zipSources.add(sources);
    }

    @Override
    public void delete(String name) {
        this.deletedEntries.add(name);
    }

    @Override
    public void close() throws IOException {
        this.bytesSources.sort(Comparator.comparing(Source::getName));
        this.zipSources.sort(Comparator.comparing(ZipSource::getName));
        for (ZipSource zipSource : this.zipSources) {
            zipSource.getSelectedEntries().sort(Comparator.comparing(Source::getName));
        }
        this.deletedEntries.sort(Comparator.naturalOrder());
        try (Archive arch = this.archive;){
            for (String toDelete : this.deletedEntries) {
                arch.delete(toDelete);
            }
            for (BytesSource source : this.bytesSources) {
                arch.add(source);
            }
            for (ZipSource zipSource : this.zipSources) {
                arch.add(zipSource);
            }
        }
    }
}

