/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

class ZipWriter
implements Closeable {
    private final File file;
    private FileChannel channel;
    private boolean isOpen;

    public ZipWriter(File file) {
        this.file = file;
        this.isOpen = false;
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        this.channel.close();
    }

    public void truncate(long size) throws IOException {
        this.ensureOpen();
        this.channel.truncate(size);
    }

    public void position(long position) throws IOException {
        this.ensureOpen();
        this.channel.position(position);
    }

    public long position() throws IOException {
        this.ensureOpen();
        return this.channel.position();
    }

    public int write(ByteBuffer buffer, long position) throws IOException {
        this.ensureOpen();
        return this.channel.write(buffer, position);
    }

    public int write(ByteBuffer buffer) throws IOException {
        this.ensureOpen();
        return this.channel.write(buffer);
    }

    public void transferFrom(FileChannel src, long position, long count) throws IOException {
        this.ensureOpen();
        for (long copied = 0L; copied != count; copied += src.transferTo(position + copied, count - copied, this.channel)) {
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isOpen) {
            return;
        }
        this.channel = FileChannel.open(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        if (!this.channel.isOpen()) {
            throw new IllegalStateException("Unable to open Channel to " + this.file.getAbsolutePath());
        }
        this.isOpen = true;
    }
}

