/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api.internal;

import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.Record;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okio.internal._Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/RecordWeigher;", "", "()V", "SIZE_OF_ARRAY_OVERHEAD", "", "SIZE_OF_BOOLEAN", "SIZE_OF_CACHE_KEY_OVERHEAD", "SIZE_OF_DOUBLE", "SIZE_OF_INT", "SIZE_OF_LONG", "SIZE_OF_MAP_OVERHEAD", "SIZE_OF_NULL", "SIZE_OF_RECORD_OVERHEAD", "byteChange", "newValue", "oldValue", "calculateBytes", "record", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "weighField", "field", "apollo-normalized-cache-api"})
public final class RecordWeigher {
    @NotNull
    public static final RecordWeigher INSTANCE = new RecordWeigher();
    private static final int SIZE_OF_BOOLEAN = 16;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    private static final int SIZE_OF_DOUBLE = 8;
    private static final int SIZE_OF_ARRAY_OVERHEAD = 16;
    private static final int SIZE_OF_MAP_OVERHEAD = 16;
    private static final int SIZE_OF_RECORD_OVERHEAD = 16;
    private static final int SIZE_OF_CACHE_KEY_OVERHEAD = 16;
    private static final int SIZE_OF_NULL = 4;

    private RecordWeigher() {
    }

    @JvmStatic
    public static final int byteChange(@Nullable Object newValue, @Nullable Object oldValue) {
        return INSTANCE.weighField(newValue) - INSTANCE.weighField(oldValue);
    }

    @JvmStatic
    public static final int calculateBytes(@NotNull Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        int size = 16 + _Utf8Kt.commonAsUtf8ToByteArray((String)record.getKey()).length;
        for (Map.Entry<String, Object> entry : record.getFields().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            size += _Utf8Kt.commonAsUtf8ToByteArray((String)key).length + INSTANCE.weighField(value);
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    private final int weighField(Object field) {
        int n;
        Object object = field;
        if (object == null) {
            n = 4;
        } else if (object instanceof String) {
            n = _Utf8Kt.commonAsUtf8ToByteArray((String)((String)field)).length;
        } else if (object instanceof Boolean) {
            n = 16;
        } else if (object instanceof Integer) {
            n = 4;
        } else if (object instanceof Long) {
            n = 8;
        } else if (object instanceof Double) {
            n = 8;
        } else if (object instanceof List) {
            int n2;
            Iterable iterable = (Iterable)field;
            int n3 = 16;
            int n4 = 0;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                void it;
                Object t;
                Object t2 = t = iterator.next();
                n2 = n4;
                boolean bl = false;
                int n5 = INSTANCE.weighField(it);
                n4 = n2 + n5;
            }
            n2 = n4;
            n = n3 + n2;
        } else if (object instanceof CacheKey) {
            n = 16 + _Utf8Kt.commonAsUtf8ToByteArray((String)((CacheKey)field).getKey()).length;
        } else if (object instanceof Map) {
            int n6;
            int n7;
            Object it;
            Object t;
            Iterable iterable = ((Map)field).keySet();
            int n8 = 16;
            int n9 = 0;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                it = t = iterator.next();
                n7 = n9;
                boolean bl = false;
                n6 = INSTANCE.weighField(it);
                n9 = n7 + n6;
            }
            n7 = n9;
            iterable = ((Map)field).values();
            n8 += n7;
            n9 = 0;
            iterator = iterable.iterator();
            while (iterator.hasNext()) {
                it = t = iterator.next();
                n7 = n9;
                boolean bl = false;
                n6 = INSTANCE.weighField(it);
                n9 = n7 + n6;
            }
            n7 = n9;
            n = n8 + n7;
        } else {
            throw new IllegalStateException(("Unknown field type in Record: '" + field + '\'').toString());
        }
        return n;
    }
}

