/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter.maven;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import java.io.File;
import java.net.ConnectException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class ConvertMojo
extends AbstractMojo {
    private static final String COMMA_AND_OR_WHITESPACE = "[,\\s]\\s*";
    private File sourceDirectory;
    private File outputDirectory;
    private String include;
    private String outputFormat;
    private int port = 8100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] sourceNames = this.getIncludedFiles();
        if (sourceNames.length == 0) {
            this.getLog().info((CharSequence)"No documents to convert.");
            return;
        }
        String[] outputFormats = this.outputFormat.split(COMMA_AND_OR_WHITESPACE);
        if (outputFormats.length == 0) {
            this.getLog().warn((CharSequence)"No outputFormat specified.");
            return;
        }
        SocketOpenOfficeConnection connection = new SocketOpenOfficeConnection(this.port);
        try {
            connection.connect();
        }
        catch (ConnectException connectException) {
            throw new MojoExecutionException("Could not connect to OpenOffice.org on port " + this.port + ". " + "Start with: soffice -accept=\"socket,host=127.0.0.1,port=" + this.port + ";urp;\"", (Exception)connectException);
        }
        this.getLog().info((CharSequence)("Converting documents from " + this.sourceDirectory + " to " + this.outputDirectory + " ..."));
        try {
            OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter((OpenOfficeConnection)connection);
            for (int inputIndex = 0; inputIndex < sourceNames.length; ++inputIndex) {
                String inputName = sourceNames[inputIndex];
                File inputFile = FileUtils.resolveFile((File)this.sourceDirectory, (String)inputName);
                for (int formatIndex = 0; formatIndex < outputFormats.length; ++formatIndex) {
                    String format = outputFormats[formatIndex];
                    String outputName = FileUtils.removeExtension((String)inputName) + "." + format;
                    File outputFile = FileUtils.resolveFile((File)this.outputDirectory, (String)outputName);
                    this.getLog().info((CharSequence)("converting " + inputName + " to " + outputName));
                    converter.convert(inputFile, outputFile);
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private String[] getIncludedFiles() {
        String[] includes = this.include.split(COMMA_AND_OR_WHITESPACE);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setIncludes(includes);
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

