/*
 * Decompiled with CFR 0.152.
 */
package com.asquera.elasticsearch.plugins.http;

import com.asquera.elasticsearch.plugins.http.auth.Client;
import com.asquera.elasticsearch.plugins.http.auth.InetAddressWhitelist;
import com.asquera.elasticsearch.plugins.http.auth.ProxyChains;
import com.asquera.elasticsearch.plugins.http.auth.XForwardedFor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class HttpBasicServer
extends HttpServer {
    private final String user;
    private final String password;
    private final InetAddressWhitelist whitelist;
    private final ProxyChains proxyChains;
    private final String xForwardHeader;
    private final boolean log;

    @Inject
    public HttpBasicServer(Settings settings, Environment environment, HttpServerTransport transport, RestController restController, NodeService nodeService) {
        super(settings, environment, transport, restController, nodeService);
        this.user = settings.get("http.basic.user", "admin");
        this.password = settings.get("http.basic.password", "admin_pw");
        boolean whitelistEnabled = settings.getAsBoolean("http.basic.ipwhitelist", Boolean.valueOf(true));
        String[] whitelisted = new String[]{};
        if (whitelistEnabled) {
            whitelisted = settings.getAsArray("http.basic.ipwhitelist", new String[]{"localhost", "127.0.0.1"});
        }
        this.whitelist = new InetAddressWhitelist(whitelisted);
        this.proxyChains = new ProxyChains(settings.getAsArray("http.basic.trusted_proxy_chains", new String[]{""}));
        this.xForwardHeader = settings.get("http.basic.xforward", "");
        this.log = settings.getAsBoolean("http.basic.log", Boolean.valueOf(true));
        Loggers.getLogger(((Object)((Object)this)).getClass()).info("using {}:{} with whitelist: {}, xforward header field: {}, trusted proxy chain: {}", new Object[]{this.user, this.password, this.whitelist, this.xForwardHeader, this.proxyChains});
    }

    public void internalDispatchRequest(HttpRequest request, HttpChannel channel) {
        if (this.log) {
            this.logRequest(request);
        }
        if (this.authorized(request)) {
            super.internalDispatchRequest(request, channel);
        } else if (this.healthCheck(request)) {
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "{\"OK\":{}}"));
        } else {
            this.logUnAuthorizedRequest(request);
            BytesRestResponse response = new BytesRestResponse(RestStatus.UNAUTHORIZED, "Authentication Required");
            response.addHeader("WWW-Authenticate", "Basic realm=\"Restricted\"");
            channel.sendResponse((RestResponse)response);
        }
    }

    private boolean isHealthCheckMethod(RestRequest.Method method) {
        RestRequest.Method[] healthCheckMethods = new RestRequest.Method[]{RestRequest.Method.GET, RestRequest.Method.HEAD};
        return Arrays.asList(healthCheckMethods).contains(method);
    }

    private boolean healthCheck(HttpRequest request) {
        return request.path().equals("/") && this.isHealthCheckMethod(request.method());
    }

    private boolean authorized(HttpRequest request) {
        return this.allowOptionsForCORS(request) || this.authBasic(request) || this.ipAuthorized(request);
    }

    private boolean ipAuthorized(HttpRequest request) {
        boolean ipAuthorized = false;
        String xForwardedFor = request.header(this.xForwardHeader);
        Client client = new Client(this.getAddress(request), this.whitelist, new XForwardedFor(xForwardedFor), this.proxyChains);
        ipAuthorized = client.isAuthorized();
        if (ipAuthorized) {
            if (this.log) {
                String template = "Ip Authorized client: {}";
                Loggers.getLogger(((Object)((Object)this)).getClass()).info(template, new Object[]{client});
            }
        } else {
            String template = "Ip Unauthorized client: {}";
            Loggers.getLogger(((Object)((Object)this)).getClass()).error(template, new Object[]{client});
        }
        return ipAuthorized;
    }

    public String getDecoded(HttpRequest request) {
        String authHeader = request.header("Authorization");
        if (authHeader == null) {
            return "";
        }
        String[] split = authHeader.split(" ", 2);
        if (split.length != 2 || !split[0].equals("Basic")) {
            return "";
        }
        try {
            return new String(Base64.decode((String)split[1]));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean authBasic(HttpRequest request) {
        String decoded = "";
        try {
            decoded = this.getDecoded(request);
            if (!decoded.isEmpty()) {
                String[] userAndPassword = decoded.split(":", 2);
                String givenUser = userAndPassword[0];
                String givenPass = userAndPassword[1];
                if (this.user.equals(givenUser) && this.password.equals(givenPass)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Retrieving of user and password failed for " + decoded + " ," + e.getMessage(), new Object[0]);
        }
        return false;
    }

    private InetAddress getAddress(HttpRequest request) {
        return ((InetSocketAddress)request.getRemoteAddress()).getAddress();
    }

    private boolean allowOptionsForCORS(HttpRequest request) {
        return request.method() == RestRequest.Method.OPTIONS;
    }

    public void logRequest(HttpRequest request) {
        String addr = this.getAddress(request).getHostAddress();
        String t = "Authorization:{}, type: {}, Host:{}, Path:{}, {}:{}, Request-IP:{}, Client-IP:{}, X-Client-IP{}";
        this.logger.info(t, new Object[]{request.header("Authorization"), request.method(), request.header("Host"), request.path(), this.xForwardHeader, request.header(this.xForwardHeader), addr, request.header("X-Client-IP"), request.header("Client-IP")});
    }

    public void logUnAuthorizedRequest(HttpRequest request) {
        String addr = this.getAddress(request).getHostAddress();
        String t = "UNAUTHORIZED type:{}, address:{}, path:{}, request:{},content:{}, credentials:{}";
        Loggers.getLogger(((Object)((Object)this)).getClass()).error(t, new Object[]{request.method(), addr, request.path(), request.params(), request.content().toUtf8(), this.getDecoded(request)});
    }
}

