/*
 * Decompiled with CFR 0.152.
 */
package com.asquera.elasticsearch.plugins.http.auth;

import com.asquera.elasticsearch.plugins.http.auth.InetAddressWhitelist;
import com.asquera.elasticsearch.plugins.http.auth.ProxyChain;
import com.asquera.elasticsearch.plugins.http.auth.ProxyChains;
import com.asquera.elasticsearch.plugins.http.auth.XForwardedFor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class Client {
    private final InetAddress requestIp;
    private final InetAddressWhitelist whitelist;
    private final XForwardedFor xForwardedFor;
    private final ProxyChains trustedProxyChains;
    private boolean trusted;
    private boolean whitelisted;
    private boolean authorized;

    public Client(InetAddress requestIp, InetAddressWhitelist whitelist, XForwardedFor xForwardedFor, ProxyChains trustedProxyChains) {
        this.requestIp = requestIp;
        this.whitelist = whitelist;
        this.xForwardedFor = xForwardedFor;
        this.trustedProxyChains = trustedProxyChains;
        this.trusted = this.checkTrusted();
        this.whitelisted = this.checkWhitelisted();
        this.authorized = this.trusted && this.whitelisted;
    }

    public String ip() {
        String ip = this.requestIp.getHostAddress();
        if (this.xForwardedFor.isSet()) {
            ip = this.remoteClientIp();
        }
        return ip;
    }

    private boolean checkTrusted() {
        boolean trusted = true;
        if (this.xForwardedFor.isSet()) {
            trusted = this.trustedProxyChains.trusts(this.requestChain());
        }
        return trusted;
    }

    private boolean checkWhitelisted() {
        boolean whitelisted = false;
        whitelisted = this.xForwardedFor.isSet() ? this.whitelist.contains(this.remoteClientIp()).booleanValue() : this.whitelist.contains(this.requestIp).booleanValue();
        return whitelisted;
    }

    private ProxyChain trustedChain() {
        return this.trustedProxyChains.trustedSubchain(this.requestChain());
    }

    private ProxyChain requestChain() {
        ArrayList<String> ipsChain = new ArrayList<String>();
        ipsChain.addAll(this.xForwardedFor.proxies());
        ipsChain.add(this.requestIp.getHostAddress());
        return new ProxyChain(ipsChain);
    }

    private String remoteClientIp() {
        String clientIp = this.xForwardedFor.client();
        if (this.trustedChain() != null) {
            List<String> trustedProxies = this.trustedChain().getProxyChain();
            List<String> proxies = this.xForwardedFor.proxies();
            proxies.removeAll(trustedProxies);
            if (proxies.size() > 0) {
                clientIp = proxies.get(proxies.size() - 1);
            }
        }
        return clientIp;
    }

    public String toString() {
        String addr = this.requestIp.getHostAddress();
        String s = "client with request ip " + addr + (this.xForwardedFor.isSet() ? ", remoteIp: " + this.remoteClientIp() : "") + " is:" + (this.authorized ? "Authorized" : "NotAuthorized") + ", " + (this.trusted ? "Trusted" : "NotTrusted") + " (X-Forwarded-For: " + this.xForwardedFor + "), " + (this.whitelisted ? "Whitelisted" : "NotWhitelisted");
        return s;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public boolean isAuthorized() {
        return this.authorized;
    }
}

