/*
 * Decompiled with CFR 0.152.
 */
package com.asquera.elasticsearch.plugins.http.auth;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.logging.Loggers;

public class InetAddressWhitelist {
    private Set<InetAddress> whitelist;

    public InetAddressWhitelist(Set<InetAddress> whitelist) {
        this.whitelist = whitelist;
    }

    public InetAddressWhitelist(String[] sWhitelist) {
        this(InetAddressWhitelist.toInetAddress(Arrays.asList(sWhitelist)));
    }

    public Boolean contains(InetAddress candidate) {
        return this.whitelist.contains(candidate);
    }

    public Boolean contains(String candidate) {
        return this.getStringWhitelist().contains(candidate);
    }

    Set<String> getStringWhitelist() {
        Iterator<InetAddress> iterator = this.whitelist.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iterator.hasNext()) {
            InetAddress next = iterator.next();
            set.add(next.getHostAddress());
        }
        return set;
    }

    static Set<InetAddress> toInetAddress(List<String> ips) {
        ArrayList<InetAddress> listIps = new ArrayList<InetAddress>();
        for (String next : ips) {
            try {
                listIps.add(InetAddress.getByName(next));
            }
            catch (UnknownHostException e) {
                String template = "an ip set in the whitelist settings raised an UnknownHostException: {}, dropping it";
                Loggers.getLogger(InetAddressWhitelist.class).info(template, new Object[]{e.getMessage()});
            }
        }
        return new HashSet<InetAddress>(listIps);
    }

    public String toString() {
        return this.whitelist.toString();
    }
}

