/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.api;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ApplicationKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern ALLOWED_KEYS = Pattern.compile("[a-zA-Z.-]+");
    private final String key;
    private transient String comparableKey;

    private ApplicationKey(String key) {
        if (!ApplicationKey.isValid(key)) {
            throw new IllegalArgumentException("'key' must match the regular expression '" + ALLOWED_KEYS + "'.");
        }
        this.key = key;
    }

    @Nonnull
    public String value() {
        return this.key;
    }

    public boolean equals(Object x) {
        if (!(x instanceof ApplicationKey)) {
            return false;
        }
        ApplicationKey that = (ApplicationKey)x;
        return this.getComparableKey().equals(that.getComparableKey());
    }

    public int hashCode() {
        return this.getComparableKey().hashCode();
    }

    public String toString() {
        return this.value();
    }

    private String getComparableKey() {
        if (this.comparableKey == null) {
            this.comparableKey = this.key.toLowerCase(Locale.ENGLISH);
        }
        return this.comparableKey;
    }

    public static ApplicationKey valueOf(String key) {
        return new ApplicationKey(key);
    }

    public static boolean isValid(@Nullable String key) {
        return key != null && ALLOWED_KEYS.matcher(key).matches();
    }
}

