/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.plugin;

import com.atlassian.fugue.Option;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

final class PluginDateTimeUtils {
    private static final DateTimeFormatter BUILD_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").withOffsetParsed();

    private PluginDateTimeUtils() {
    }

    static Option<DateTime> fromPluginString(String date) {
        try {
            return Option.some((Object)BUILD_DATE_FORMAT.parseDateTime(date));
        }
        catch (IllegalArgumentException e) {
            return Option.none();
        }
    }

    static String toPluginString(DateTime date) {
        return BUILD_DATE_FORMAT.print((ReadableInstant)date);
    }
}

