/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.spi.ClusterLockDao;
import com.atlassian.beehive.spi.ClusterLockStatus;
import com.atlassian.beehive.spi.ClusterNodeHeartBeatDao;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseClusterLock
implements ClusterLock {
    private static final int INITIAL_SLEEP_MILLIS = 100;
    private static final int MAX_SLEEP_MILLIS = 10000;
    private static final Logger log = LoggerFactory.getLogger(DatabaseClusterLock.class);
    private final String lockName;
    private final ClusterLockDao clusterLockDao;
    private final ClusterNodeHeartBeatDao clusterNodeHeartBeatDao;
    private final String nodeId;

    public DatabaseClusterLock(String lockName, ClusterLockDao clusterLockDao, ClusterNodeHeartBeatDao clusterNodeHeartBeatDao) {
        this.lockName = lockName;
        this.clusterLockDao = clusterLockDao;
        this.clusterNodeHeartBeatDao = clusterNodeHeartBeatDao;
        this.nodeId = clusterNodeHeartBeatDao.getNodeId();
    }

    public void lock() {
        boolean wasInterrupted = false;
        while (true) {
            try {
                this.lockInterruptibly();
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        int sleepTimeMillis = 100;
        boolean success;
        while (!(success = this.tryLock())) {
            Thread.sleep(sleepTimeMillis);
            sleepTimeMillis = Math.min(sleepTimeMillis * 2, 10000);
        }
        return;
    }

    public boolean tryLock() {
        ClusterLockStatus clusterLockStatus;
        if (log.isDebugEnabled()) {
            log.debug("Attempt to get cluster lock '{}' by {}.", (Object)this.lockName, (Object)Thread.currentThread());
        }
        if ((clusterLockStatus = this.getClusterLockStatus()).getLockedByNode() != null && !clusterLockStatus.getLockedByNode().equals(this.nodeId)) {
            if (log.isDebugEnabled()) {
                log.debug("Cluster lock '{}' currently held by node '{}'.", (Object)this.lockName, (Object)clusterLockStatus.getLockedByNode());
            }
            clusterLockStatus = this.unlockIfDead(clusterLockStatus);
        }
        boolean success = clusterLockStatus.getLockedByNode() == null ? this.clusterLockDao.tryUpdateAcquireLock(this.lockName, this.nodeId) : false;
        if (log.isDebugEnabled()) {
            if (success) {
                log.debug("Cluster lock '{}' was acquired by {}.", (Object)this.lockName, (Object)Thread.currentThread());
            } else {
                log.debug("Acquisition of cluster lock '{}' by {} failed.", (Object)this.lockName, (Object)Thread.currentThread());
            }
        }
        return success;
    }

    public boolean tryLock(long waitTime, @Nonnull TimeUnit unit) throws InterruptedException {
        long timeout = System.currentTimeMillis() + unit.toMillis(waitTime);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long sleepTimeMillis = 100L;
        boolean success;
        while (!(success = this.tryLock())) {
            long remainingWaitTime = timeout - System.currentTimeMillis();
            if (remainingWaitTime <= 0L) {
                return false;
            }
            sleepTimeMillis = Math.min(sleepTimeMillis, remainingWaitTime);
            Thread.sleep(sleepTimeMillis);
            sleepTimeMillis = Math.min(sleepTimeMillis * 2L, 10000L);
        }
        return true;
    }

    public void unlock() {
        this.clusterLockDao.unlock(this.lockName, this.nodeId);
    }

    @Nonnull
    public Condition newCondition() {
        throw new UnsupportedOperationException("newCondition() not supported in ClusterLock");
    }

    private ClusterLockStatus getClusterLockStatus() {
        ClusterLockStatus lock = this.clusterLockDao.getClusterLockStatusByName(this.lockName);
        if (lock != null) {
            return lock;
        }
        this.clusterLockDao.insertEmptyClusterLock(this.lockName);
        return this.clusterLockDao.getClusterLockStatusByName(this.lockName);
    }

    private ClusterLockStatus unlockIfDead(ClusterLockStatus lock) {
        this.clusterNodeHeartBeatDao.getNodeId();
        return lock;
    }
}

