/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.beehive.DatabaseClusterLock;
import com.atlassian.beehive.spi.ClusterLockDao;
import com.atlassian.beehive.spi.ClusterNodeHeartBeatDao;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class DatabaseClusterLockService
implements ClusterLockService {
    private final ConcurrentMap<String, ClusterLock> lockMap = new ConcurrentHashMap<String, ClusterLock>();
    private final ClusterLockDao clusterLockDao;
    private final ClusterNodeHeartBeatDao clusterNodeHeartBeatDao;

    public DatabaseClusterLockService(ClusterLockDao clusterLockDao, ClusterNodeHeartBeatDao clusterNodeHeartBeatDao) {
        this.clusterLockDao = clusterLockDao;
        this.clusterNodeHeartBeatDao = clusterNodeHeartBeatDao;
    }

    public ClusterLock getLockForName(@Nonnull String lockName) {
        ClusterLock lock = (ClusterLock)this.lockMap.get(lockName);
        if (lock != null) {
            return lock;
        }
        this.lockMap.putIfAbsent(lockName, new DatabaseClusterLock(lockName, this.clusterLockDao, this.clusterNodeHeartBeatDao));
        return (ClusterLock)this.lockMap.get(lockName);
    }
}

