/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.AbstractCommitRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitRequest
extends AbstractCommitRequest {
    private final Set<String> propertyKeys;

    private CommitRequest(Builder builder) {
        super(builder);
        this.propertyKeys = builder.propertyKeys.build();
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.propertyKeys;
    }

    public static class Builder
    extends AbstractCommitRequest.AbstractCommitRequestBuilder<Builder> {
        private final ImmutableSet.Builder<String> propertyKeys = ImmutableSet.builder();

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            super(repository, commitId);
        }

        @Nonnull
        public CommitRequest build() {
            return new CommitRequest(this);
        }

        @Override
        @Nonnull
        public Builder maxMessageLength(int value) {
            return (Builder)super.maxMessageLength(value);
        }

        @Override
        @Nonnull
        public Builder path(@Nullable String value) {
            return (Builder)super.path(value);
        }

        @Nonnull
        public Builder propertyKey(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value);
            return this.self();
        }

        @Nonnull
        public Builder propertyKeys(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value, values);
            return this.self();
        }

        @Nonnull
        public Builder propertyKeys(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, values);
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

