/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.permission.GlobalPermissionEvent;
import com.atlassian.bitbucket.event.permission.PermissionGrantRequestedEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public class GlobalPermissionGrantRequestedEvent
extends GlobalPermissionEvent
implements PermissionGrantRequestedEvent {
    private final CancelState cancelState;

    public GlobalPermissionGrantRequestedEvent(@Nonnull Object source, @Nonnull Permission permission, @Nullable String affectedGroup, @Nullable ApplicationUser affectedUser, @Nonnull CancelState cancelState) {
        super(source, permission, affectedGroup, affectedUser);
        this.cancelState = Objects.requireNonNull(cancelState, "cancelState");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

