/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class HookScriptUpdateRequest {
    private final InputSupplier<InputStream> content;
    private final String description;
    private final String name;
    private final String pluginKey;
    private final HookScript script;

    private HookScriptUpdateRequest(Builder builder) {
        this.content = builder.content;
        this.description = builder.description;
        this.name = builder.name;
        this.pluginKey = builder.pluginKey;
        this.script = builder.script;
    }

    @Nonnull
    public Optional<InputSupplier<InputStream>> getContent() {
        return Optional.ofNullable(this.content);
    }

    @Nonnull
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Nonnull
    public HookScript getScript() {
        return this.script;
    }

    public static class Builder
    extends BuilderSupport {
        private final HookScript script;
        private InputSupplier<InputStream> content;
        private String description;
        private String name;
        private String pluginKey;

        public Builder(@Nonnull HookScript script) {
            this.script = Objects.requireNonNull(script, "script");
            this.description = script.getDescription().orElse(null);
            this.name = script.getName();
            this.pluginKey = script.getPluginKey();
        }

        @Nonnull
        public HookScriptUpdateRequest build() {
            return new HookScriptUpdateRequest(this);
        }

        @Nonnull
        public Builder content(@Nonnull InputSupplier<InputStream> value) {
            this.content = Objects.requireNonNull(value, "content");
            return this;
        }

        @Nonnull
        public Builder content(@Nonnull String value) {
            return this.content(Builder.requireNonBlank(value, "content").getBytes(StandardCharsets.UTF_8));
        }

        @Nonnull
        public Builder content(@Nonnull byte[] value) {
            if (Objects.requireNonNull(value, "content").length == 0) {
                throw new IllegalArgumentException("Hook script contents cannot be empty");
            }
            this.content = () -> new ByteArrayInputStream(value);
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Builder.requireNonBlank(value, "name");
            return this;
        }

        @Nonnull
        public Builder pluginKey(@Nonnull String value) {
            this.pluginKey = Builder.requireNonBlank(value, "pluginKey");
            return this;
        }
    }
}

