/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestChangeScope;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestChangesRequest
extends AbstractPullRequestRequest {
    private final PullRequestChangeScope changeScope;
    private final String sinceId;
    private final String untilId;
    private final boolean withComments;

    private PullRequestChangesRequest(Builder builder) {
        super(builder);
        this.changeScope = builder.changeScope;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
        this.withComments = builder.withComments;
    }

    @Nonnull
    public PullRequestChangeScope getChangeScope() {
        return this.changeScope;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nullable
    public String getUntilId() {
        return this.untilId;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private PullRequestChangeScope changeScope;
        private String sinceId;
        private String untilId;
        private boolean withComments;

        public Builder(@Nonnull PullRequestChangesRequest request) {
            super(Objects.requireNonNull(request, "request").getRepositoryId(), request.getPullRequestId());
            this.changeScope = request.getChangeScope();
            this.withComments = request.isWithComments();
        }

        public Builder(@Nonnull PullRequest pullRequest) {
            this(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository().getId(), pullRequest.getId());
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
            this.changeScope = PullRequestChangeScope.ALL;
            this.withComments = true;
        }

        @Nonnull
        public PullRequestChangesRequest build() {
            return new PullRequestChangesRequest(this);
        }

        @Nonnull
        public Builder changeScope(@Nonnull PullRequestChangeScope value) {
            this.changeScope = Objects.requireNonNull(value, "changeScope");
            return this.self();
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = value;
            return this.self();
        }

        @Nonnull
        public Builder untilId(@Nullable String value) {
            this.untilId = value;
            return this.self();
        }

        @Nonnull
        public Builder withComments(boolean value) {
            this.withComments = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

