/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.AbstractRepositoryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RepositoryCreateRequest
extends AbstractRepositoryRequest {
    private final String defaultBranch;
    private final Project project;
    private final String scmId;

    private RepositoryCreateRequest(Builder builder) {
        super(builder);
        this.defaultBranch = builder.defaultBranch;
        this.project = builder.project;
        this.scmId = builder.scmId;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    @Nonnull
    public String getScmId() {
        return this.scmId;
    }

    public static class Builder
    extends AbstractRepositoryRequest.AbstractBuilder<Builder> {
        private String defaultBranch;
        private Project project;
        private String scmId;

        public Builder() {
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
            this.project = repository.getProject();
            this.scmId = repository.getScmId();
        }

        public Builder(@Nonnull RepositoryCreateRequest request) {
            super(request);
            this.project = request.getProject();
            this.scmId = request.getScmId();
        }

        @Nonnull
        public RepositoryCreateRequest build() {
            Preconditions.checkState((this.project != null ? 1 : 0) != 0, (Object)"The project in which to create the repository is required");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.scmId), (Object)"The SCM type for the new repository is required");
            return new RepositoryCreateRequest(this);
        }

        @Nonnull
        public Builder defaultBranch(@Nullable String value) {
            this.defaultBranch = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder project(@Nonnull Project value) {
            this.project = Objects.requireNonNull(value, "project");
            return this.self();
        }

        @Nonnull
        public Builder scmId(@Nonnull String value) {
            this.scmId = Builder.checkNotBlank(value, "scmId");
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

