/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommonAncestorCommandParameters
extends AbstractCommandParameters {
    private final Set<String> commitIds;
    private final Repository secondaryRepository;

    private CommonAncestorCommandParameters(Builder builder) {
        this.commitIds = builder.commitIds.build();
        Preconditions.checkArgument((this.commitIds.size() > 0 ? 1 : 0) != 0, (Object)"Must specify at least 1 commit ID");
        this.secondaryRepository = builder.secondaryRepository;
    }

    @Nonnull
    public Set<String> getCommitIds() {
        return this.commitIds;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> commitIds = ImmutableSet.builder();
        private Repository secondaryRepository;

        @Nonnull
        public CommonAncestorCommandParameters build() {
            return new CommonAncestorCommandParameters(this);
        }

        @Nonnull
        public Builder commitId(@Nullable String value, String ... moreValues) {
            Builder.addIf(Objects::nonNull, this.commitIds, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder commitId(@Nullable Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.commitIds, values);
            return this;
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this;
        }
    }
}

