/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.ContentTreeContext;
import com.atlassian.bitbucket.scm.AbstractCommitCommandParameters;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DirectoryCommandParameters
extends AbstractCommitCommandParameters {
    private final boolean recursive;
    private final boolean withSizes;

    private DirectoryCommandParameters(Builder builder) {
        super(builder);
        if (StringUtils.isBlank((CharSequence)this.getCommitId())) {
            throw new IllegalStateException("A commit ID must be provided when retrieving directory contents");
        }
        this.recursive = builder.recursive;
        this.withSizes = builder.withSizes;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isWithSizes() {
        return this.withSizes;
    }

    @Nonnull
    public ContentTreeContext toContext() {
        return new ContentTreeContext.Builder(this.getCommitId()).recursive(this.isRecursive()).build();
    }

    public static class Builder
    extends AbstractCommitCommandParameters.AbstractCommitParametersBuilder<Builder> {
        private boolean recursive;
        private boolean withSizes;

        @Nonnull
        public DirectoryCommandParameters build() {
            return new DirectoryCommandParameters(this);
        }

        @Nonnull
        public Builder recurse(boolean value) {
            this.recursive = value;
            return this.self();
        }

        @Nonnull
        public Builder withSizes(boolean value) {
            this.withSizes = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

