/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EditFileCommandParameters
extends AbstractCommandParameters {
    private final ApplicationUser author;
    private final Branch branch;
    private final ApplicationUser committer;
    private final InputSupplier<InputStream> content;
    private final String message;
    private final String path;
    private final String sourceCommitId;
    private final String targetBranch;

    public EditFileCommandParameters(Builder builder) {
        this.author = builder.author;
        this.branch = builder.branch;
        this.committer = (ApplicationUser)MoreObjects.firstNonNull((Object)builder.committer, (Object)builder.author);
        this.content = builder.content;
        this.message = builder.message;
        this.path = builder.path;
        this.sourceCommitId = builder.sourceCommitId;
        this.targetBranch = Objects.requireNonNull(builder.targetBranch, "targetBranch");
    }

    @Nonnull
    public ApplicationUser getAuthor() {
        return this.author;
    }

    @Nonnull
    public Optional<Branch> getBranch() {
        return Optional.ofNullable(this.branch);
    }

    @Nonnull
    public ApplicationUser getCommitter() {
        return this.committer;
    }

    @Nonnull
    public InputSupplier<InputStream> getContent() {
        return this.content;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Optional<String> getSourceCommitId() {
        return Optional.ofNullable(this.sourceCommitId);
    }

    @Nonnull
    public String getTargetBranch() {
        return this.targetBranch;
    }

    public static class Builder {
        private final Branch branch;
        private final String path;
        private ApplicationUser author;
        private ApplicationUser committer;
        private InputSupplier<InputStream> content;
        private String message;
        private String sourceCommitId;
        private String targetBranch;

        public Builder(@Nullable Branch branch, @Nonnull String path) {
            this.branch = branch;
            this.path = EditFileCommandParameters.requireNonBlank(path, "path");
            if (branch != null) {
                this.targetBranch = branch.getId();
            }
        }

        @Nonnull
        public Builder author(@Nonnull ApplicationUser value) {
            this.author = Objects.requireNonNull(value, "author");
            return this;
        }

        @Nonnull
        public EditFileCommandParameters build() {
            Objects.requireNonNull(this.author, "author");
            Objects.requireNonNull(this.content, "content");
            EditFileCommandParameters.requireNonBlank(this.message, "message");
            return new EditFileCommandParameters(this);
        }

        @Nonnull
        public Builder committer(@Nonnull ApplicationUser value) {
            this.committer = Objects.requireNonNull(value, "committer");
            return this;
        }

        @Nonnull
        public Builder content(@Nonnull InputSupplier<InputStream> value) {
            this.content = Objects.requireNonNull(value, "content");
            return this;
        }

        @Nonnull
        public Builder message(@Nonnull String value) {
            this.message = EditFileCommandParameters.requireNonBlank(value, "message");
            return this;
        }

        @Nonnull
        public Builder sourceCommitId(@Nullable String value) {
            this.sourceCommitId = value;
            return this;
        }

        @Nonnull
        public Builder targetBranch(@Nonnull String value) {
            this.targetBranch = Objects.requireNonNull(value, "targetBranch");
            return this;
        }
    }
}

