/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.content.FileContext;
import com.atlassian.bitbucket.scm.AbstractCommitCommandParameters;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class FileCommandParameters
extends AbstractCommitCommandParameters {
    private final boolean annotated;
    private final int maxLineLength;

    private FileCommandParameters(Builder builder) {
        super(builder);
        if (StringUtils.isBlank((CharSequence)this.getCommitId())) {
            throw new IllegalStateException("A commit ID must provided when retrieving file contents");
        }
        if (StringUtils.isBlank((CharSequence)this.getPath())) {
            throw new IllegalStateException("A path must be provided when retrieving file contents");
        }
        this.maxLineLength = builder.maxLineLength;
        this.annotated = builder.annotated;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    @Nonnull
    public FileContext toContext() {
        return new FileContext.Builder(this.getCommitId()).maxLineLength(this.getMaxLineLength()).build();
    }

    public static class Builder
    extends AbstractCommitCommandParameters.AbstractCommitParametersBuilder<Builder> {
        private boolean annotated;
        private int maxLineLength;

        @Nonnull
        public Builder annotate(boolean value) {
            this.annotated = value;
            return this;
        }

        @Nonnull
        public FileCommandParameters build() {
            return new FileCommandParameters(this);
        }

        @Nonnull
        public Builder maxLineLength(int value) {
            this.maxLineLength = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

