/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.botocss;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import org.jsoup.nodes.Document;

public enum DocumentFunctions implements Function<Document, Document>
{
    NOOP,
    PRETTY_PRINT(new Function<Document, Document>(){

        public Document apply(Document document) {
            document.outputSettings().prettyPrint(true);
            document.outputSettings().indentAmount(4);
            return null;
        }
    }),
    ZERO_INDENT(new Function<Document, Document>(){

        public Document apply(Document document) {
            document.outputSettings().indentAmount(0);
            return null;
        }
    });

    private Function<Document, Document> delegate = Functions.identity();

    private DocumentFunctions() {
    }

    private DocumentFunctions(Function<Document, Document> delegate) {
        this.delegate = delegate;
    }

    public Document apply(Document document) {
        return (Document)this.delegate.apply((Object)document);
    }
}

