/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory.jmx;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.memory.jmx.MemoryCacheMXBeanImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCacheMXBeanRegistrar {
    static final String MBEAN_NAME_PATTERN = "com.google.common.cache:type=CacheStatistics,CacheManager=JIRA Cache Manager,name=%s";
    private final Logger logger = LoggerFactory.getLogger(MemoryCacheMXBeanRegistrar.class);
    private MBeanServer mbeanServer;
    private CacheManager cacheManager;
    private Set<ObjectName> registeredMBeans = new HashSet<ObjectName>();

    public void enableCollectingJMXMetrics(@Nonnull MBeanServer mbeanServer, @Nonnull CacheManager cacheManager) {
        this.mbeanServer = mbeanServer;
        this.cacheManager = cacheManager;
        Collection caches = cacheManager.getManagedCaches();
        for (ManagedCache cache : caches) {
            this.registerMBean(cache.getName());
        }
    }

    public void registerMBean(@Nonnull String cacheName) {
        if (this.mbeanServer != null) {
            try {
                ObjectName name = this.buildName(cacheName);
                if (this.registeredMBeans.contains(name)) {
                    this.logger.debug("MBean: " + name.getCanonicalName() + " has been registered previously");
                    return;
                }
                MemoryCacheMXBeanImpl mbean = new MemoryCacheMXBeanImpl(this.cacheManager, cacheName);
                this.mbeanServer.registerMBean(mbean, name);
                this.registeredMBeans.add(name);
            }
            catch (Exception e) {
                this.logger.warn("Could not register JMX MBean for Guava Cache: " + cacheName, (Throwable)e);
            }
        }
    }

    public void unregisterMBeans() {
        if (this.mbeanServer != null) {
            for (ObjectName mbeanName : this.registeredMBeans) {
                try {
                    this.mbeanServer.unregisterMBean(mbeanName);
                }
                catch (Exception e) {
                    this.logger.warn("Could not unregister JMX MBean: " + mbeanName.getCanonicalName(), (Throwable)e);
                }
            }
            this.registeredMBeans.clear();
            this.mbeanServer = null;
        }
    }

    private ObjectName buildName(String cacheName) throws MalformedObjectNameException {
        return new ObjectName(String.format(MBEAN_NAME_PATTERN, cacheName));
    }
}

