/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.service.exceptions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.validation.ValidationError;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.util.FugueConversionUtil;
import com.atlassian.fugue.Option;
import com.google.common.collect.Iterables;
import java.util.Optional;

@ExperimentalApi
public class ServiceException
extends RuntimeException {
    private final ValidationResult validationResult;

    public ServiceException() {
        this.validationResult = null;
    }

    public ServiceException(String message) {
        super(message);
        this.validationResult = null;
    }

    public ServiceException(Throwable throwable) {
        super(throwable);
        this.validationResult = null;
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
        this.validationResult = null;
    }

    public ServiceException(String message, ValidationResult validationResult) {
        super(message);
        this.validationResult = validationResult;
    }

    @Deprecated
    public Option<ValidationResult> getOptionalValidationResult() {
        return FugueConversionUtil.toComOption(this.optionalValidationResult());
    }

    public Optional<ValidationResult> optionalValidationResult() {
        return Optional.ofNullable(this.validationResult);
    }

    @Override
    public String toString() {
        Iterable<ValidationError> errors;
        Optional<ValidationResult> option;
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getName());
        String message = this.getMessage();
        if (message != null) {
            b.append(": ").append(message);
        }
        if ((option = this.optionalValidationResult()).isPresent() && (errors = option.get().getErrors()).iterator().hasNext()) {
            b.append(": ");
            b.append(Iterables.toString((Iterable)Iterables.transform(errors, input -> input.getMessage().toString())));
        }
        return b.toString();
    }
}

