/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.azure.AzureFilteringEnabledChecker;
import com.atlassian.crowd.directory.AzureAdDirectory;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.cache.DeltaQueryCacheRefresher;
import com.atlassian.crowd.directory.cache.UserFilterableNonDeltaQueryCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresherFactory;
import com.atlassian.crowd.directory.ldap.cache.EventTokenChangedCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.RemoteDirectoryCacheRefresher;
import com.atlassian.crowd.directory.synchronisation.cache.CacheRefresher;
import com.atlassian.crowd.directory.synchronisation.cache.UsnChangedCacheRefresher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdServerCacheRefresherFactory
implements CacheRefresherFactory {
    private static final Logger log = LoggerFactory.getLogger(CrowdServerCacheRefresherFactory.class);
    private final AzureFilteringEnabledChecker azureFilteringEnabledChecker;

    public CrowdServerCacheRefresherFactory(AzureFilteringEnabledChecker azureFilteringEnabledChecker) {
        this.azureFilteringEnabledChecker = azureFilteringEnabledChecker;
    }

    public CacheRefresher createRefresher(RemoteDirectory remoteDirectory) {
        if (remoteDirectory instanceof MicrosoftActiveDirectory) {
            return new UsnChangedCacheRefresher((MicrosoftActiveDirectory)remoteDirectory);
        }
        if (remoteDirectory instanceof RemoteCrowdDirectory) {
            RemoteDirectoryCacheRefresher fullSyncCacheRefresher = new RemoteDirectoryCacheRefresher(remoteDirectory);
            return new EventTokenChangedCacheRefresher((RemoteCrowdDirectory)remoteDirectory, (CacheRefresher)fullSyncCacheRefresher);
        }
        if (remoteDirectory instanceof AzureAdDirectory) {
            AzureAdDirectory azureAdDirectory = (AzureAdDirectory)remoteDirectory;
            if (azureAdDirectory.isGroupFilteringEnabled() && this.azureFilteringEnabledChecker.isEnabled()) {
                log.debug("For filtered Azure AD directory {}, returning non-incremental cache refresher", (Object)remoteDirectory.getDirectoryId());
                return new UserFilterableNonDeltaQueryCacheRefresher(azureAdDirectory);
            }
            if (azureAdDirectory.supportsDeltaQueryApi()) {
                log.debug("For Azure AD directory {}, returning delta query cache refresher", (Object)remoteDirectory.getDirectoryId());
                return new DeltaQueryCacheRefresher(azureAdDirectory);
            }
            log.debug("For Azure AD directory {}, returning non-incremental cache refresher", (Object)remoteDirectory.getDirectoryId());
            return new RemoteDirectoryCacheRefresher((RemoteDirectory)azureAdDirectory);
        }
        return new RemoteDirectoryCacheRefresher(remoteDirectory);
    }
}

