/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.AuthenticationManager;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthenticatorImpl
implements HttpAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(HttpAuthenticatorImpl.class);
    private final AuthenticationManager authenticationManager;
    private final CrowdHttpTokenHelper tokenHelper;

    public HttpAuthenticatorImpl(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        this.tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
    }

    private void invalidateClient(HttpServletRequest request, HttpServletResponse response, String token) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug("Invalidating the Crowd token: " + token);
        }
        CookieConfiguration cookieConfig = null;
        if (response != null) {
            SOAPCookieInfo soapCookieInfo = this.getSecurityServerClient().getCookieInfo();
            cookieConfig = new CookieConfiguration(soapCookieInfo.getDomain(), soapCookieInfo.isSecure(), "crowd.token_key");
        }
        this.tokenHelper.removeCrowdToken(request, response, (ClientProperties)this.getSoapClientProperties(), cookieConfig);
    }

    @Override
    public void setPrincipalToken(HttpServletRequest request, HttpServletResponse response, String token) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting the Crowd token: " + token);
        }
        CookieConfiguration cookieConfig = null;
        if (response != null) {
            SOAPCookieInfo soapCookieInfo = this.getSecurityServerClient().getCookieInfo();
            cookieConfig = new CookieConfiguration(soapCookieInfo.getDomain(), soapCookieInfo.isSecure(), "crowd.token_key");
        }
        this.tokenHelper.setCrowdToken(request, response, token, (ClientProperties)this.getSoapClientProperties(), cookieConfig);
    }

    @Override
    public SOAPPrincipal getPrincipal(HttpServletRequest request) throws InvalidAuthorizationTokenException, RemoteException, InvalidTokenException, InvalidAuthenticationException {
        return this.getSecurityServerClient().findPrincipalByToken(this.getToken(request));
    }

    @Override
    public String getToken(HttpServletRequest request) throws InvalidTokenException {
        String token = this.tokenHelper.getCrowdToken(request, this.getCookieTokenKey());
        if (token == null) {
            throw new InvalidTokenException("Unable to find a valid principal token.");
        }
        return token;
    }

    @Override
    public boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) throws InvalidAuthorizationTokenException, RemoteException, ApplicationAccessDeniedException, InvalidAuthenticationException {
        long timeSpread;
        String token;
        HttpSession session = request.getSession();
        try {
            token = this.getToken(request);
        }
        catch (InvalidTokenException e) {
            logger.debug("Non authenticated request, unable to find a valid Crowd token.");
            return false;
        }
        Date lastValidation = (Date)session.getAttribute(this.getSoapClientProperties().getSessionLastValidation());
        if (lastValidation != null && this.getSoapClientProperties().getSessionValidationInterval() > 0L && (timeSpread = lastValidation.getTime() + TimeUnit.MINUTES.toMillis(this.getSoapClientProperties().getSessionValidationInterval())) > System.currentTimeMillis()) {
            return true;
        }
        if (this.authenticationManager.isAuthenticated(token, this.getValidationFactors(request))) {
            this.setPrincipalToken(request, response, token);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        block5: {
            String token;
            block4: {
                token = null;
                try {
                    UserAuthenticationContext userAuthenticationContext = this.getPrincipalAuthenticationContext(request, response, username, password);
                    token = this.authenticationManager.authenticate(userAuthenticationContext);
                    if (token != null) break block4;
                }
                catch (Throwable throwable) {
                    if (token == null) {
                        this.invalidateClient(request, response, null);
                    } else {
                        this.setPrincipalToken(request, response, token);
                    }
                    throw throwable;
                }
                this.invalidateClient(request, response, null);
                break block5;
            }
            this.setPrincipalToken(request, response, token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticateWithoutValidatingPassword(HttpServletRequest request, HttpServletResponse response, String username) throws ApplicationAccessDeniedException, InvalidAuthenticationException, InvalidAuthorizationTokenException, InactiveAccountException, RemoteException {
        block5: {
            String token;
            block4: {
                token = null;
                try {
                    UserAuthenticationContext userAuthenticationContext = this.getPrincipalAuthenticationContext(request, response, username, null);
                    token = this.authenticationManager.authenticateWithoutValidatingPassword(userAuthenticationContext);
                    if (token != null) break block4;
                }
                catch (Throwable throwable) {
                    if (token == null) {
                        this.invalidateClient(request, response, null);
                    } else {
                        this.setPrincipalToken(request, response, token);
                    }
                    throw throwable;
                }
                this.invalidateClient(request, response, null);
                break block5;
            }
            this.setPrincipalToken(request, response, token);
        }
    }

    @Override
    public String verifyAuthentication(String username, String password, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        PasswordCredential credential = new PasswordCredential(password);
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext();
        userAuthenticationContext.setApplication(this.getSoapClientProperties().getApplicationName());
        userAuthenticationContext.setCredential(credential);
        userAuthenticationContext.setName(username);
        userAuthenticationContext.setValidationFactors(validationFactors);
        return this.authenticationManager.authenticate(userAuthenticationContext);
    }

    @Override
    public void verifyAuthentication(String username, String password) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        this.authenticationManager.authenticate(username, password);
    }

    @Override
    public ValidationFactor[] getValidationFactors(HttpServletRequest request) {
        ArrayList<ValidationFactor> validationFactors = new ArrayList<ValidationFactor>();
        if (request != null) {
            String remoteAddressXForwardFor;
            String remoteAddress = request.getRemoteAddr();
            if (remoteAddress != null && remoteAddress.length() > 0) {
                validationFactors.add(new ValidationFactor("remote_address", remoteAddress));
            }
            if ((remoteAddressXForwardFor = request.getHeader("X-Forwarded-For")) != null && !remoteAddressXForwardFor.equals(remoteAddress)) {
                validationFactors.add(new ValidationFactor("X-Forwarded-For", remoteAddressXForwardFor));
            }
        }
        return validationFactors.toArray(new ValidationFactor[validationFactors.size()]);
    }

    @Override
    public void logoff(HttpServletRequest request, HttpServletResponse response) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        String token = null;
        try {
            token = this.getToken(request);
            this.authenticationManager.invalidate(token);
        }
        catch (InvalidTokenException e) {
            // empty catch block
        }
        this.invalidateClient(request, response, token);
    }

    @Override
    public UserAuthenticationContext getPrincipalAuthenticationContext(HttpServletRequest request, HttpServletResponse response, String username, String password) {
        PasswordCredential credential = new PasswordCredential(password);
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext();
        userAuthenticationContext.setApplication(this.getSoapClientProperties().getApplicationName());
        userAuthenticationContext.setCredential(credential);
        userAuthenticationContext.setName(username);
        userAuthenticationContext.setValidationFactors(this.getValidationFactors(request));
        return userAuthenticationContext;
    }

    @Override
    public SoapClientProperties getSoapClientProperties() {
        return this.getSecurityServerClient().getSoapClientProperties();
    }

    protected String getCookieTokenKey() {
        return this.getSoapClientProperties().getCookieTokenKey();
    }

    @Override
    public SecurityServerClient getSecurityServerClient() {
        return this.authenticationManager.getSecurityServerClient();
    }
}

