/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;
import com.atlassian.crowd.manager.avatar.AvatarReference;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextAdapter;

public class JpegPhotoContextMapper
implements ContextMapperWithRequiredAttributes<AvatarReference.BlobAvatar> {
    private static final Logger logger = LoggerFactory.getLogger(JpegPhotoContextMapper.class);
    private final String propertyName;

    public JpegPhotoContextMapper() {
        this("jpegPhoto");
    }

    public JpegPhotoContextMapper(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return Collections.singleton(this.propertyName);
    }

    @Override
    public AvatarReference.BlobAvatar mapFromContext(Object ctx) {
        DirContextAdapter dc = (DirContextAdapter)ctx;
        Object obj = dc.getObjectAttribute(this.propertyName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return new AvatarReference.BlobAvatar("image/jpeg", (byte[])obj);
        }
        logger.debug("Unexpected type for jpegPhoto: {}", obj.getClass());
        return null;
    }
}

