/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper.attribute.group;

import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class RFC4519MemberDnMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberDNs";
    private final String groupMemberAttribute;
    private final boolean relaxedDnStandardisation;

    public RFC4519MemberDnMapper(String groupMemberAttribute, boolean relaxedDnStandardisation) {
        this.groupMemberAttribute = groupMemberAttribute;
        this.relaxedDnStandardisation = relaxedDnStandardisation;
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public Set<String> getValues(NameAttributesPair nameAttributesPair) throws Exception {
        List<String> memberList = nameAttributesPair.getAttributeValuesForName(this.groupMemberAttribute);
        if (memberList == null) {
            return ImmutableSet.of();
        }
        ImmutableSet members = ImmutableSet.copyOf(memberList);
        ImmutableSet.Builder standardDnSetBuilder = ImmutableSet.builderWithExpectedSize((int)members.size());
        for (String memberDn : members) {
            String standardisedDn = DNStandardiser.standardise(memberDn, !this.relaxedDnStandardisation);
            standardDnSetBuilder.add((Object)standardisedDn);
        }
        return standardDnSetBuilder.build();
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return Collections.singleton(this.groupMemberAttribute);
    }
}

