/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.exception.mapper;

import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.exception.AnonymousUserPermissionRuntimeException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class AnonymousUserPermissionRuntimeExceptionMapper
implements ExceptionMapper<AnonymousUserPermissionRuntimeException> {
    private I18nResolver i18nResolver;

    @Inject
    public AnonymousUserPermissionRuntimeExceptionMapper(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    public Response toResponse(AnonymousUserPermissionRuntimeException exception) {
        return this.unauthorizedResponse(exception);
    }

    private Response unauthorizedResponse(Exception e) {
        String message = this.i18nResolver.getText("crowd.administrators.anonymous.exception");
        ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of(e), message);
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errorEntity).build();
    }
}

