/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugins.scm.utils;

import com.atlassian.crucible.scm.SCMModule;
import com.atlassian.crucible.scm.SCMRepository;
import com.atlassian.fisheye.plugin.configuration.ModuleConfigurationStore;
import com.atlassian.fisheye.plugins.scm.utils.Configurable;
import com.atlassian.fisheye.plugins.scm.utils.SimpleConfiguration;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.thoughtworks.xstream.XStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class ConfigurableSCMModule<T extends SimpleConfiguration>
implements SCMModule,
Configurable<List<T>> {
    private ModuleDescriptor moduleDescriptor;
    private final ModuleConfigurationStore moduleConfigurationStore;
    private final ResettableLazyReference<List<SCMRepository>> repos = new ResettableLazyReference<List<SCMRepository>>(){

        protected List<SCMRepository> create() throws Exception {
            return ConfigurableSCMModule.this.loadConfiguration();
        }
    };

    protected ConfigurableSCMModule(ModuleConfigurationStore moduleConfigurationStore) {
        this.moduleConfigurationStore = moduleConfigurationStore;
    }

    protected XStream getXStream() {
        XStream xstream = new XStream();
        xstream.setClassLoader(this.moduleDescriptor.getPlugin().getClassLoader());
        return xstream;
    }

    public void setModuleDescriptor(ModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    public List<T> getConfiguration() {
        byte[] configData = this.moduleConfigurationStore.getConfiguration(this.moduleDescriptor);
        if (configData != null) {
            try {
                return (List)this.getXStream().fromXML(new String(configData, "UTF8"));
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading configuration: " + configData, e);
            }
        }
        return new ArrayList();
    }

    @Override
    public void setConfiguration(List<T> config) {
        try {
            this.moduleConfigurationStore.putConfiguration(this.moduleDescriptor, this.getXStream().toXML(config).getBytes("UTF8"));
            this.repos.reset();
            this.configChanged();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 encoding not supported", e);
        }
    }

    public Collection<SCMRepository> getRepositories() {
        return (Collection)this.repos.get();
    }

    private List<SCMRepository> loadConfiguration() {
        ArrayList<SCMRepository> rs = new ArrayList<SCMRepository>();
        Iterator iterator = this.getConfiguration().iterator();
        while (iterator.hasNext()) {
            SimpleConfiguration config = (SimpleConfiguration)iterator.next();
            rs.add(this.createRepository(config));
        }
        return rs;
    }

    protected abstract SCMRepository createRepository(T var1);

    protected void configChanged() {
    }
}

