/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugins.scm.utils;

import com.atlassian.crucible.spi.FisheyePluginUtilities;
import com.atlassian.fisheye.plugin.web.RequiresXsrfCheck;
import com.atlassian.fisheye.plugin.web.helpers.VelocityHelper;
import com.atlassian.fisheye.plugins.scm.utils.Configurable;
import com.atlassian.fisheye.plugins.scm.utils.SimpleConfiguration;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public abstract class SimpleConfigurationServlet<T extends SimpleConfiguration>
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)"fisheye");
    private final PluginAccessor pluginAccessor;
    private final FisheyePluginUtilities fisheyePluginUtilities;
    private final VelocityHelper velocityHelper;

    public SimpleConfigurationServlet(PluginAccessor pluginAccessor, FisheyePluginUtilities fisheyePluginUtilities, VelocityHelper velocityHelper) {
        this.pluginAccessor = pluginAccessor;
        this.fisheyePluginUtilities = fisheyePluginUtilities;
        this.velocityHelper = velocityHelper;
    }

    private Configurable<List<T>> getModule() {
        Object o = this.getDescriptor().getModule();
        try {
            return (Configurable)o;
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("The module with key '" + this.getProviderPluginModuleKey() + "' does not implement the Configurable<List<T>> interface. The module has the class " + o.getClass());
        }
    }

    private ModuleDescriptor<?> getDescriptor() {
        ModuleDescriptor descriptor = this.pluginAccessor.getEnabledPluginModule(this.getProviderPluginModuleKey());
        if (descriptor == null) {
            throw new RuntimeException("No descriptor with key '" + this.getProviderPluginModuleKey() + "' was found. Make sure that the value returned by getProviderPluginModuleKey() matches the key in atlassian-plugin.xml");
        }
        return descriptor;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Configurable<List<T>> module = this.getModule();
        String repoName = req.getParameter("name");
        if (repoName == null) {
            this.showList(module, req, resp);
        } else {
            if (req.getParameter("delete") != null) {
                log.warn((Object)"As of 3.2.0 release XSRF protection was introduced which denies 'delete' action using GET request. Please use POST for it. You can read more about XSRF protection in 3.2.0 Release Notes");
            }
            this.showRepositoryForm(module, repoName, null, req, resp);
        }
    }

    @RequiresXsrfCheck
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("delete") != null) {
            this.delete(req, resp);
        } else {
            this.save(req, resp);
        }
    }

    private void delete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Configurable<List<List<T>>> module = this.getModule();
        String repoName = req.getParameter("name");
        List<T> configs = module.getConfiguration();
        for (int i = 0; i < configs.size(); ++i) {
            if (!((SimpleConfiguration)configs.get(i)).getName().equals(repoName)) continue;
            configs.remove(i);
            break;
        }
        module.setConfiguration(configs);
        resp.sendRedirect(req.getRequestURL().toString());
    }

    private void save(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Configurable<List<List<T>>> module = this.getModule();
        String name = this.filterName(req.getParameter("name"));
        T config = this.getConfig(module, name);
        try {
            BeanUtils.populate(config, (Map)req.getParameterMap());
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting properties on " + config);
        }
        if (name != null) {
            config.setName(name);
        }
        List<T> configs = module.getConfiguration();
        boolean found = false;
        for (int i = 0; i < configs.size(); ++i) {
            if (!((SimpleConfiguration)configs.get(i)).getName().equals(config.getName())) continue;
            configs.set(i, config);
            found = true;
            break;
        }
        if (!found) {
            if (this.fisheyePluginUtilities.isRepoNameInUse(name, req) || this.fisheyePluginUtilities.isRepoDisplayNameInUse(name, req)) {
                this.showRepositoryForm(module, null, "A repository named " + name + " already exists", req, resp);
                return;
            }
            configs.add(config);
        }
        module.setConfiguration(configs);
        resp.sendRedirect(req.getRequestURL().toString());
    }

    private String filterName(String name) {
        return name == null ? null : name.replaceAll("[\\s\\W]", "");
    }

    private T getConfig(Configurable<List<T>> module, String name) {
        for (SimpleConfiguration c : module.getConfiguration()) {
            if (!c.getName().equals(name)) continue;
            return (T)c;
        }
        return this.defaultConfig();
    }

    protected abstract T defaultConfig();

    protected abstract String getProviderPluginModuleKey();

    protected abstract String getTemplatePackage();

    private void showRepositoryForm(Configurable<List<T>> module, String repoName, String errorMessage, HttpServletRequest req, HttpServletResponse resp) {
        T config = this.getConfig(module, repoName);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (errorMessage != null) {
            params.put("errorMessage", errorMessage);
        }
        if (config != null) {
            params.put("config", config);
            this.render(params, req, resp, "/edit.vm");
        } else {
            params.put("name", repoName);
            this.render(params, req, resp, "/nosuchrepo.vm");
        }
    }

    private void showList(Configurable<List<T>> module, HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("configs", module.getConfiguration());
        this.render(params, req, resp, "/list.vm");
    }

    void render(Map<String, Object> parameters, HttpServletRequest request, HttpServletResponse response, String templateName) {
        try {
            request.setAttribute("decorator", (Object)"atl.admin");
            request.setAttribute("admin.sectionName", (Object)this.getDescriptor().getName());
            response.setContentType("text/html");
            parameters.put("STATICDIR", this.fisheyePluginUtilities.getStaticDir());
            parameters.put("request", request);
            this.velocityHelper.renderVelocityTemplate(this.getTemplatePackage() + templateName, parameters, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new RuntimeException("Error rendering template '" + this.getTemplatePackage() + templateName + "'", e);
        }
    }
}

