/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extension.provider.api;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import java.util.Optional;
import javax.annotation.Nonnull;

@PublicApi
@PublicSpi
public interface ExtensionTag {

    @PublicApi
    public static class Tagged<T> {
        private final Optional<ExtensionTag> maybeTag;
        private final Optional<T> maybeContent;

        public Tagged(ExtensionTag tag) {
            this.maybeTag = Optional.of(tag);
            this.maybeContent = Optional.empty();
        }

        public Tagged(T content) {
            this.maybeTag = Optional.empty();
            this.maybeContent = Optional.of(content);
        }

        public Tagged(ExtensionTag tag, T content) {
            this.maybeTag = Optional.of(tag);
            this.maybeContent = Optional.of(content);
        }

        @Nonnull
        public Optional<ExtensionTag> maybeTag() {
            return this.maybeTag;
        }

        public boolean isTagged() {
            return this.maybeTag().isPresent();
        }

        @Nonnull
        public ExtensionTag getTag() {
            return this.maybeTag().get();
        }

        @Nonnull
        public Optional<T> maybeContent() {
            return this.maybeContent;
        }

        public boolean hasContent() {
            return this.maybeContent().isPresent();
        }

        @Nonnull
        public T getContent() {
            return this.maybeContent().get();
        }
    }
}

