/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.scm;

import com.atlassian.crucible.scm.ChangeSet;
import com.atlassian.crucible.scm.RevisionKey;
import com.cenqua.crucible.model.Principal;
import java.util.List;

public interface ChangelogBrowser {
    public ChangeSets listChanges(Principal var1, String var2, String var3, boolean var4, String var5, boolean var6, int var7);

    public static class ChangeSets {
        private boolean newerChangeSetsExist;
        private boolean olderChangeSetsExist;
        private List<ChangeSet> changeSets;

        public ChangeSets(boolean newerChangeSetsExist, boolean olderChangeSetsExist, List<ChangeSet> changeSets) {
            this.newerChangeSetsExist = newerChangeSetsExist;
            this.olderChangeSetsExist = olderChangeSetsExist;
            this.changeSets = changeSets;
        }

        public boolean isNewerChangeSetsExist() {
            return this.newerChangeSetsExist;
        }

        public boolean isOlderChangeSetsExist() {
            return this.olderChangeSetsExist;
        }

        public List<ChangeSet> getChangeSets() {
            return this.changeSets;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ChangeSets: olderExist = " + this.olderChangeSetsExist + ", newerExist = " + this.newerChangeSetsExist);
            sb.append(this.changeSets != null && this.changeSets.size() > 0 ? this.toStringChangeSets() : " no changesets.");
            return sb.toString();
        }

        private String toStringChangeSets() {
            StringBuilder sb = new StringBuilder();
            for (ChangeSet cs : this.changeSets) {
                sb.append(cs.getCsid() + ", " + cs.getComment() + ", " + cs.getDate() + ": (\n");
                for (RevisionKey rk : cs.getRevisions()) {
                    sb.append(rk.getPath() + " - " + rk.getRevision() + "\n");
                }
                sb.append(")\n");
            }
            return sb.toString();
        }
    }
}

