/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.data;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.crucible.spi.data.CommentDataImpl;
import com.atlassian.crucible.spi.data.CustomFieldData;
import com.atlassian.crucible.spi.data.GeneralCommentData;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.data.VersionedCommentData;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={GeneralCommentData.class})
public class VersionedLineCommentData
extends VersionedCommentData
implements Serializable {
    private String fromLineRange;
    private String toLineRange;
    @XmlElementWrapper(name="lineRanges")
    @XmlElement(name="lineRange")
    private List<LineRangeDetail> details;

    @Deprecated
    public VersionedLineCommentData() {
    }

    @Deprecated
    public VersionedLineCommentData(PermId<ReviewItemData> reviewItemId, String message, boolean draft, boolean deleted, boolean defectRaised, boolean defectApproved, CommentData.Status readStatus, UserData user, Date createDate, String fromLineRange, String toLineRange, List<GeneralCommentData> replies, Map<String, CustomFieldData> metrics, String parentPermId) {
        this(reviewItemId, message, null, draft, deleted, defectRaised, defectApproved, readStatus, user, createDate, fromLineRange, toLineRange, null, replies, metrics, parentPermId);
    }

    @Deprecated
    public VersionedLineCommentData(PermId<ReviewItemData> reviewItemId, String message, String messageAsHtml, boolean draft, boolean deleted, boolean defectRaised, boolean defectApproved, CommentData.Status readStatus, UserData user, Date createDate, String fromLineRange, String toLineRange, List<GeneralCommentData> replies, Map<String, CustomFieldData> metrics, String parentPermId) {
        this(reviewItemId, message, messageAsHtml, draft, deleted, defectRaised, defectApproved, readStatus, user, createDate, fromLineRange, toLineRange, null, replies, metrics, parentPermId);
    }

    @Deprecated
    public VersionedLineCommentData(PermId<ReviewItemData> reviewItemId, String message, boolean draft, boolean deleted, boolean defectRaised, boolean defectApproved, CommentData.Status readStatus, UserData user, Date createDate, String fromLineRange, String toLineRange, String permId, List<GeneralCommentData> replies, Map<String, CustomFieldData> metrics, String parentPermId) {
        this(reviewItemId, message, null, draft, deleted, defectRaised, defectApproved, readStatus, user, createDate, fromLineRange, toLineRange, permId, replies, metrics, parentPermId);
    }

    @Deprecated
    public VersionedLineCommentData(PermId<ReviewItemData> reviewItemId, String message, String messageAsHtml, boolean draft, boolean deleted, boolean defectRaised, boolean defectApproved, CommentData.Status readStatus, UserData user, Date createDate, String fromLineRange, String toLineRange, String permId, List<GeneralCommentData> replies, Map<String, CustomFieldData> metrics, String parentPermId) {
        super(reviewItemId, message, messageAsHtml, draft, defectApproved, readStatus, user, deleted, permId, createDate, defectRaised, replies, metrics, parentPermId);
        this.fromLineRange = fromLineRange;
        this.toLineRange = toLineRange;
    }

    public String getFromLineRange() {
        return this.fromLineRange;
    }

    public String getToLineRange() {
        return this.toLineRange;
    }

    public void setFromLineRange(String fromLineRange) {
        this.fromLineRange = fromLineRange;
    }

    public void setToLineRange(String toLineRange) {
        this.toLineRange = toLineRange;
    }

    public List<LineRangeDetail> getLineRanges() {
        return this.details;
    }

    public void setLineRanges(List<LineRangeDetail> details) {
        this.details = details;
    }

    public static VersionedLineCommentBuilder builder() {
        return new VersionedLineCommentBuilder();
    }

    public static class VersionedLineCommentBuilder
    extends CommentDataImpl.CommentDataBuilder<VersionedLineCommentBuilder, VersionedLineCommentData> {
        private PermId<ReviewItemData> reviewItemId = null;
        private List<LineRangeDetail> rangeDetails = Lists.newArrayList();
        private String toLineRange = null;
        private String fromLineRange = null;

        private VersionedLineCommentBuilder() {
        }

        public VersionedLineCommentBuilder reviewItemId(PermId<ReviewItemData> reviewItemId) {
            this.reviewItemId = reviewItemId;
            return this;
        }

        @Deprecated
        public VersionedLineCommentBuilder toLineRange(String toLineRange) {
            this.toLineRange = toLineRange;
            return this;
        }

        @Deprecated
        public VersionedLineCommentBuilder fromLineRange(String fromLineRange) {
            this.fromLineRange = fromLineRange;
            return this;
        }

        public VersionedLineCommentBuilder addRangeDetail(String revision, String range) {
            this.rangeDetails.add(new LineRangeDetail(revision, range));
            return this;
        }

        @Override
        public VersionedLineCommentData build() {
            VersionedLineCommentData versionedLineCommentData = new VersionedLineCommentData(this.reviewItemId, this.message, this.messageAsHtml, this.draft, this.deleted, this.defectRaised, this.defectApproved, this.readStatus, this.user, this.createDate, this.fromLineRange, this.toLineRange, this.permaId, this.replies, this.metrics, this.parentCommentPermId);
            if (!this.rangeDetails.isEmpty()) {
                versionedLineCommentData.setLineRanges(Lists.newArrayList(this.rangeDetails));
            }
            return versionedLineCommentData;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class LineRangeDetail {
        @XmlAttribute
        private String revision;
        @XmlAttribute
        private String range;

        @Deprecated
        public LineRangeDetail() {
        }

        @Deprecated
        public LineRangeDetail(String revision, String range) {
            this.revision = revision;
            this.range = range;
        }

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineRangeDetail that = (LineRangeDetail)o;
            if (this.range != null ? !this.range.equals(that.range) : that.range != null) {
                return false;
            }
            return !(this.revision != null ? !this.revision.equals(that.revision) : that.revision != null);
        }

        public int hashCode() {
            int result = this.revision != null ? this.revision.hashCode() : 0;
            result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
            return result;
        }
    }
}

