/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.services;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.ActionData;
import com.atlassian.crucible.spi.data.AnchorData;
import com.atlassian.crucible.spi.data.ChangesetData;
import com.atlassian.crucible.spi.data.CommentData;
import com.atlassian.crucible.spi.data.CommentResolutionData;
import com.atlassian.crucible.spi.data.CommentResolutionStatus;
import com.atlassian.crucible.spi.data.CrucibleRevisionData;
import com.atlassian.crucible.spi.data.CustomFieldDefData;
import com.atlassian.crucible.spi.data.CustomFilterData;
import com.atlassian.crucible.spi.data.DetailedReviewData;
import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.crucible.spi.data.GeneralCommentData;
import com.atlassian.crucible.spi.data.PatchGroupData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.ReviewerData;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.crucible.spi.data.VersionInfo;
import com.atlassian.crucible.spi.data.VersionedLineCommentData;
import com.atlassian.crucible.spi.services.ChangeSetContentTooLargeException;
import com.atlassian.crucible.spi.services.FileData;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.crucible.spi.services.PatchAnchorFailedException;
import com.atlassian.crucible.spi.services.ReviewContentTooLargeException;
import java.util.List;
import java.util.Set;

public interface ReviewService {
    public ReviewData createReview(ReviewData var1);

    public DetailedReviewData createDetailedReview(DetailedReviewData var1);

    public ReviewData createReviewFromPatch(ReviewData var1, String var2) throws ChangeSetContentTooLargeException;

    public ReviewData createReviewFromPatch(ReviewData var1, String var2, AnchorData var3) throws PatchAnchorFailedException, ChangeSetContentTooLargeException;

    public ReviewData createSnippetReview(ReviewData var1, String var2, String var3);

    public ReviewData createReviewFromChangeSets(ReviewData var1, String var2, List<ChangesetData> var3) throws ChangeSetContentTooLargeException;

    public ReviewData addChangesetsToReview(PermId<ReviewData> var1, String var2, List<ChangesetData> var3) throws ChangeSetContentTooLargeException, ReviewContentTooLargeException;

    public DetailedReviewData addReviewRevisions(PermId<ReviewData> var1, List<CrucibleRevisionData> var2) throws IllegalArgumentException, NotFoundException, NotPermittedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException;

    public FisheyeReviewItemData addReviewItem(PermId<ReviewData> var1, FisheyeReviewItemData var2) throws IllegalArgumentException, NotFoundException, NotPermittedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException;

    public FisheyeReviewItemData setReviewItem(PermId<ReviewData> var1, PermId<ReviewItemData> var2, FisheyeReviewItemData var3) throws IllegalArgumentException, NotFoundException, NotPermittedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException;

    public ReviewItemData addReviewItemRevisions(PermId<ReviewData> var1, PermId<ReviewItemData> var2, List<String> var3) throws IllegalArgumentException, NotFoundException, NotPermittedException, ReviewContentTooLargeException;

    public void removeReviewItemRevisions(PermId<ReviewData> var1, PermId<ReviewItemData> var2, List<String> var3) throws IllegalArgumentException, NotFoundException, NotPermittedException;

    public ReviewData addPatchToReview(PermId<ReviewData> var1, String var2) throws ReviewContentTooLargeException, ChangeSetContentTooLargeException;

    public ReviewData addPatchToReview(PermId<ReviewData> var1, String var2, AnchorData var3) throws PatchAnchorFailedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException;

    public ReviewData addPatchToReview(PermId<ReviewData> var1, String var2, AnchorData var3, String var4) throws PatchAnchorFailedException, ChangeSetContentTooLargeException, ReviewContentTooLargeException;

    public List<PatchGroupData> removePatchFromReview(PermId<ReviewData> var1, int var2);

    public FisheyeReviewItemData addFileToReview(PermId<ReviewData> var1, FileData var2, FileData var3) throws ReviewContentTooLargeException;

    public List<ReviewData> getAllReviews(boolean var1);

    public ReviewData getReview(PermId<ReviewData> var1, boolean var2);

    public ReviewData getReview(PermId<ReviewData> var1) throws NotFoundException, NotPermittedException;

    public DetailedReviewData getReviewDetails(PermId<ReviewData> var1);

    public List<ActionData> getAllowedActionsForReview(PermId<ReviewData> var1);

    public List<ActionData> getAllowedTransitionsForReview(PermId<ReviewData> var1);

    public List<ReviewData> getReviewsInStates(ReviewData.State[] var1, boolean var2);

    public Set<ReviewerData> getAllReviewers(PermId<ReviewData> var1);

    public Set<ReviewerData> getCompletedReviewers(PermId<ReviewData> var1);

    public Set<ReviewerData> getUncompletedReviewers(PermId<ReviewData> var1);

    public void addReviewers(PermId<ReviewData> var1, String[] var2);

    public void removeReviewer(PermId<ReviewData> var1, String var2);

    public List<UserData> remindIncompleteReviewers(PermId<ReviewData> var1);

    public List<UserData> remindIncompleteReviewers(PermId<ReviewData> var1, List<String> var2, String var3);

    public ReviewItemData addFisheyeDiff(PermId<ReviewData> var1, String var2, String var3, String var4, String var5, String var6) throws ReviewContentTooLargeException;

    public void removeReviewItem(PermId<ReviewData> var1, PermId<ReviewItemData> var2);

    public List<ReviewItemData> getReviewItemsForReview(PermId<ReviewData> var1);

    public VersionedLineCommentData addComment(PermId<ReviewItemData> var1, VersionedLineCommentData var2);

    public GeneralCommentData addGeneralComment(PermId<ReviewData> var1, GeneralCommentData var2);

    public CommentData getComment(PermId<CommentData> var1);

    public CommentData getComment(PermId<CommentData> var1, boolean var2);

    public void updateComment(PermId<CommentData> var1, GeneralCommentData var2);

    public void setCommentResolution(PermId<CommentData> var1, CommentResolutionStatus var2);

    public CommentResolutionData getCommentResolution(PermId<CommentData> var1);

    public void removeComment(PermId<CommentData> var1) throws NotFoundException;

    public GeneralCommentData addReply(PermId<CommentData> var1, GeneralCommentData var2);

    public void postComment(PermId<CommentData> var1);

    public void postComments(PermId<ReviewData> var1);

    public DetailedReviewData markAllCommentsAsRead(PermId<ReviewData> var1);

    public CommentData markCommentAsRead(PermId<CommentData> var1);

    public CommentData markCommentAsLeaveUnread(PermId<CommentData> var1);

    public void completeReview(PermId<ReviewData> var1, boolean var2);

    public void completeReview(PermId<ReviewData> var1, boolean var2, boolean var3);

    public ReviewData closeReviewWithSummary(PermId<ReviewData> var1, String var2);

    public ReviewData closeReviewWithSummary(PermId<ReviewData> var1, String var2, boolean var3);

    public List<GeneralCommentData> getGeneralComments(PermId<ReviewData> var1);

    public List<GeneralCommentData> getGeneralComments(PermId<ReviewData> var1, boolean var2);

    public List<VersionedLineCommentData> getVersionedComments(PermId<ReviewItemData> var1);

    public List<VersionedLineCommentData> getVersionedComments(PermId<ReviewItemData> var1, boolean var2);

    public List<VersionedLineCommentData> getAllRevisionComments(PermId<ReviewData> var1);

    public List<VersionedLineCommentData> getAllRevisionComments(PermId<ReviewData> var1, boolean var2);

    public List<GeneralCommentData> getReplies(PermId<CommentData> var1);

    public List<GeneralCommentData> getReplies(PermId<CommentData> var1, boolean var2);

    public List<ReviewData> getUncompletedReviewsForUser(String var1);

    public List<ReviewData> getFilteredReviews(String var1, boolean var2);

    public List<ReviewData> getCustomFilterReviews(CustomFilterData var1, boolean var2);

    public List<ReviewData> getAllReviewsForItem(String var1, String var2, boolean var3);

    public FisheyeReviewItemData getReviewItem(PermId<ReviewData> var1, PermId<ReviewItemData> var2);

    public VersionInfo getVersionInfo();

    public void deleteReview(PermId<ReviewData> var1);

    public void tryAutomaticJiraLinking(PermId<ReviewData> var1);

    public List<PatchGroupData> getReviewPatches(PermId<ReviewData> var1);

    public ReviewData changeState(PermId<ReviewData> var1, String var2);

    public ReviewData changeState(PermId<ReviewData> var1, String var2, boolean var3);

    public ReviewData changeState(PermId<ReviewData> var1, Action var2);

    public ReviewData changeState(PermId<ReviewData> var1, Action var2, boolean var3);

    public List<ReviewData> getChildReviews(PermId<ReviewData> var1);

    public List<ReviewData> getChildReviews(PermId<ReviewData> var1, boolean var2);

    public List<CustomFieldDefData> getMetrics(int var1);

    public boolean hasPermission(PermId<ReviewData> var1, String var2) throws NotFoundException;

    public String extractReviewTitle(String var1);

    public void checkChangesetSizeAcceptable(List<ChangesetData> var1, String var2) throws ChangeSetContentTooLargeException;

    public static enum Action {
        Approve("action:approveReview"),
        Abandon("action:abandonReview"),
        Submit("action:submitReview"),
        Reject("action:rejectReview"),
        Summarize("action:summarizeReview"),
        Close("action:closeReview"),
        Reopen("action:reopenReview"),
        Recover("action:recoverReview");

        private String actionString;

        private Action(String actionString) {
            this.actionString = actionString;
        }

        public String getActionString() {
            return this.actionString;
        }

        public static Action getByActionString(String actionString) {
            for (Action a : Action.values()) {
                if (!a.getActionString().equals(actionString)) continue;
                return a;
            }
            throw new IllegalArgumentException("Bad actionString '" + actionString + "'");
        }
    }
}

