/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.services;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.Objects;

@ExperimentalApi
public class ReviewerSearchResult
implements Comparable<ReviewerSearchResult> {
    private final Type type;
    private final UserResult user;
    private final GroupResult group;

    public ReviewerSearchResult(UserResult user) {
        this.type = Type.USER;
        this.user = user;
        this.group = null;
    }

    public ReviewerSearchResult(GroupResult group) {
        this.type = Type.GROUP;
        this.user = null;
        this.group = group;
    }

    private String getDisplayLabel() {
        return Type.GROUP.equals((Object)this.type) ? this.getGroup().getName() : this.getUser().getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviewerSearchResult that = (ReviewerSearchResult)o;
        return this.type == that.type && Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.group, (Object)that.group);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.user, this.group});
    }

    public Type getType() {
        return this.type;
    }

    public UserResult getUser() {
        return this.user;
    }

    public GroupResult getGroup() {
        return this.group;
    }

    @Override
    public int compareTo(ReviewerSearchResult o) {
        return this.getDisplayLabel().compareToIgnoreCase(o.getDisplayLabel());
    }

    public String toString() {
        return "ReviewerSearchResult{, type=" + (Object)((Object)this.type) + ", user=" + this.user + ", group=" + this.group + '}';
    }

    @ExperimentalApi
    public static class UserResult {
        private final String userName;
        private final int id;
        private final String displayName;
        private final String avatarImageUrl;

        public UserResult(int id, String userName, String displayName, String avatarImageUrl) {
            this.avatarImageUrl = avatarImageUrl;
            this.userName = userName;
            this.id = id;
            this.displayName = displayName;
        }

        public String getUserName() {
            return this.userName;
        }

        public int getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getAvatarImageUrl() {
            return this.avatarImageUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserResult that = (UserResult)o;
            return this.id == that.id && Objects.equal((Object)this.userName, (Object)that.userName) && Objects.equal((Object)this.displayName, (Object)that.displayName) && Objects.equal((Object)this.avatarImageUrl, (Object)that.avatarImageUrl);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.userName, this.id, this.displayName, this.avatarImageUrl});
        }

        public String toString() {
            return "UserResult{avatarImageUrl='" + this.avatarImageUrl + '\'' + ", userName='" + this.userName + '\'' + ", id=" + this.id + ", displayName='" + this.displayName + '\'' + '}';
        }
    }

    @ExperimentalApi
    public static class GroupResult {
        private String name;

        public GroupResult(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupResult that = (GroupResult)o;
            return Objects.equal((Object)this.name, (Object)that.name);
        }

        public String toString() {
            return "GroupResult{name='" + this.name + '\'' + '}';
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name});
        }
    }

    public static enum Type {
        USER,
        GROUP;

    }
}

