/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.workflow;

import com.atlassian.crucible.workflow.ResultAction;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ResultMessage {
    private final String message;
    private final String restMessage;
    private final String title;
    private final List<ResultAction> actions;

    public ResultMessage(String title, String message) {
        this(title, message, Collections.emptyList());
    }

    public ResultMessage(String title, String message, String restMessage) {
        this(title, message, restMessage, Collections.emptyList());
    }

    public ResultMessage(String title, String message, List<ResultAction> actions) {
        this(title, message, null, actions);
    }

    public ResultMessage(String title, String message, @Nullable String restMessage, List<ResultAction> actions) {
        this.message = message;
        this.title = title;
        this.restMessage = restMessage;
        this.actions = ImmutableList.copyOf(actions);
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRestMessage() {
        return this.restMessage;
    }

    public List<ResultAction> getActions() {
        return this.actions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResultMessage{");
        sb.append("message='").append(this.message).append('\'');
        sb.append(", title='").append(this.title).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultMessage that = (ResultMessage)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.title, that.title);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.title);
    }
}

