/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.workflow;

import com.atlassian.crucible.workflow.ResultMessage;
import com.atlassian.crucible.workflow.ResultSeverity;
import java.util.Objects;

public class ValidationResult {
    private final ResultSeverity severity;
    private final String resultKey;
    private final ResultMessage message;

    private ValidationResult(ResultSeverity severity, String resultKey, ResultMessage message) {
        this.severity = severity;
        this.resultKey = resultKey;
        this.message = message;
    }

    public ResultMessage getMessage() {
        return this.message;
    }

    public ResultSeverity getResultSeverity() {
        return this.severity;
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public static ValidationResult ok() {
        return new ValidationResult(ResultSeverity.OK, null, null);
    }

    public static ValidationResult warn(String resultKey, ResultMessage message) {
        return new ValidationResult(ResultSeverity.WARN, resultKey, message);
    }

    public static ValidationResult error(String resultKey, ResultMessage message) {
        return new ValidationResult(ResultSeverity.ERROR, resultKey, message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationResult validationResult = (ValidationResult)o;
        return this.severity == validationResult.severity && Objects.equals(this.resultKey, validationResult.resultKey) && Objects.equals(this.message, validationResult.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.resultKey, this.message});
    }

    public String toString() {
        return "Result{severity=" + (Object)((Object)this.severity) + ", resultKey='" + this.resultKey + '\'' + ", message=" + this.message + '}';
    }
}

